/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDeviationWeighting
extends Operator {
    private static final String[] NORMALIZATIONS = new String[]{"none", "average", "minimum", "maximum"};
    private static final int NONE = 0;
    private static final int AVERAGE = 1;
    private static final int MINIMUM = 2;
    private static final int MAXIMUM = 3;

    public StandardDeviationWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        int normalization = this.getParameterAsInt("normalize");
        AttributeWeights weights = new AttributeWeights();
        for (Attribute attribute : exampleSet.getAttributes()) {
            NumericalAttributeStatistics stats = (NumericalAttributeStatistics)attribute.getStatistics();
            double data = Math.sqrt(stats.getVariance());
            switch (normalization) {
                case 0: {
                    break;
                }
                case 1: {
                    data /= stats.getAverage();
                    break;
                }
                case 2: {
                    data /= stats.getMinimum();
                    break;
                }
                case 3: {
                    data /= stats.getMaximum();
                    break;
                }
            }
            data = Math.abs(data);
            weights.setWeight(attribute.getName(), data);
        }
        return new IOObject[]{weights};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{AttributeWeights.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory("normalize", "Indicates if the standard deviation should be divided by the minimum, maximum, or average of the attribute.", NORMALIZATIONS, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

