/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWeighting
extends IndividualOperator {
    private double compareWeight = 0.0;
    private double[] weights = null;

    public SimpleWeighting(double compareWeight, double[] weights) {
        this.compareWeight = compareWeight;
        this.weights = weights;
    }

    @Override
    public List<Individual> operate(Individual individual) {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        LinkedList<Individual> l = new LinkedList<Individual>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (exampleSet.getWeight(attribute) != this.compareWeight) continue;
            int w = 0;
            while (w < this.weights.length) {
                AttributeWeightedExampleSet nes = (AttributeWeightedExampleSet)exampleSet.clone();
                nes.setWeight(attribute, this.weights[w]);
                l.add(new Individual(nes));
                ++w;
            }
        }
        return l;
    }
}

