/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.optimization.Optimization;
import edu.udo.cs.yale.tools.math.optimization.ec.pso.PSOOptimization;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSOWeighting
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class, PerformanceVector.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private Optimization optimization;
    private ExampleSet exampleSet;

    public PSOWeighting(OperatorDescription description) {
        super(description);
        this.addValue(new Value("generation", "The number of the current generation."){

            public double getValue() {
                return PSOWeighting.this.optimization.getGeneration();
            }
        });
        this.addValue(new Value("performance", "The performance of the current generation (main criterion)."){

            public double getValue() {
                return PSOWeighting.this.optimization.getBestFitnessInGeneration();
            }
        });
        this.addValue(new Value("best", "The performance of the best individual ever (main criterion)."){

            public double getValue() {
                return PSOWeighting.this.optimization.getBestFitnessEver();
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.exampleSet = this.getInput(ExampleSet.class);
        this.optimization = new PSOWeightingOptimization(this, this.exampleSet.getAttributes().size(), RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed")));
        this.optimization.optimize();
        double[] globalBestWeights = this.optimization.getBestValuesEver();
        AttributeWeightedExampleSet result = this.createWeightedExampleSet(globalBestWeights);
        AttributeWeights weights = new AttributeWeights();
        int index = 0;
        for (Attribute attribute : result.getAttributes()) {
            weights.setWeight(attribute.getName(), globalBestWeights[index++]);
        }
        return new IOObject[]{result, weights, this.optimization.getBestPerformanceEver()};
    }

    private PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
        boolean onlyZeros = true;
        int i = 0;
        while (i < individual.length) {
            if (individual[i] != 0.0) {
                onlyZeros = false;
                break;
            }
            ++i;
        }
        if (onlyZeros) {
            return null;
        }
        AttributeWeightedExampleSet evaluationSet = this.createWeightedExampleSet(individual).createCleanClone();
        Operator operatorChain = this.getOperator(0);
        IOObject[] operatorChainInput = new IOObject[]{evaluationSet};
        IOContainer innerResult = operatorChain.apply(this.getInput().append(operatorChainInput));
        return innerResult.remove(PerformanceVector.class);
    }

    private AttributeWeightedExampleSet createWeightedExampleSet(double[] weights) {
        AttributeWeightedExampleSet result = new AttributeWeightedExampleSet((ExampleSet)this.exampleSet.clone());
        int index = 0;
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            result.setWeight(attribute, weights[index++]);
        }
        return result;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("population_size", "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("maximum_number_of_generations", "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("generations_without_improval", "Stop criterion: Stop after n generations without improval of the performance (-1: perform all generations).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeDouble("inertia_weight", "The (initial) weight for the old weighting.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("local_best_weight", "The weight for the individual's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("global_best_weight", "The weight for the population's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("dynamic_inertia_weight", "If set to true the inertia weight is improved during run.", true));
        types.add(new ParameterTypeDouble("min_weight", "The lower bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("max_weight", "The upper bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }

    private static class PSOWeightingOptimization
    extends PSOOptimization {
        private PSOWeighting op;

        public PSOWeightingOptimization(PSOWeighting op, int individualSize, RandomGenerator random) throws UndefinedParameterError {
            super(op.getParameterAsInt("population_size"), individualSize, op.getParameterAsInt("maximum_number_of_generations"), op.getParameterAsInt("generations_without_improval"), op.getParameterAsDouble("inertia_weight"), op.getParameterAsDouble("local_best_weight"), op.getParameterAsDouble("global_best_weight"), op.getParameterAsDouble("min_weight"), op.getParameterAsDouble("max_weight"), op.getParameterAsBoolean("dynamic_inertia_weight"), random);
            this.op = op;
        }

        public PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
            return this.op.evaluateIndividual(individual);
        }

        public void nextIteration() throws OperatorException {
            super.nextIteration();
            this.op.inApplyLoop();
        }
    }
}

