/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.dialog.AttributeWeightsDialog;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.LogService;

public class InteractiveAttributeWeighting
extends Operator {
    public InteractiveAttributeWeighting(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        AttributeWeights weights = null;
        ExampleSet exampleSet = null;
        try {
            weights = this.getInput(AttributeWeights.class);
        }
        catch (MissingIOObjectException e) {
            LogService.logMessage(String.valueOf(this.getName()) + ": No feature weights found in input. Trying to find an example set...", 2);
            weights = new AttributeWeights();
            try {
                exampleSet = this.getInput(ExampleSet.class);
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), 1.0);
                }
                LogService.logMessage(String.valueOf(this.getName()) + ": ExampleSet found! Initially all attributes will be used with weight 1.", 2);
            }
            catch (MissingIOObjectException mioe) {
                LogService.logMessage(String.valueOf(this.getName()) + ": No examples found! Starting dialog without any weights.", 2);
            }
        }
        AttributeWeightsDialog attributeWeightsDialog = new AttributeWeightsDialog(weights);
        attributeWeightsDialog.setVisible(true);
        if (attributeWeightsDialog.isOk()) {
            weights = attributeWeightsDialog.getAttributeWeights();
        }
        if (exampleSet != null) {
            return new IOObject[]{exampleSet, weights};
        }
        return new IOObject[]{weights};
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{AttributeWeights.class};
    }
}

