/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaAttributeWeighting
extends Operator
implements TechnicalInformationHandler {
    public static final String[] WEKA_ATTRIBUTE_EVALUATORS = WekaTools.getWekaClasses(AttributeEvaluator.class);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaAttributeWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        AttributeWeights weights = new AttributeWeights();
        AttributeEvaluator evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        LogService.logMessage(String.valueOf(this.getName()) + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "WeightingInstances", 4);
        try {
            LogService.logMessage(String.valueOf(this.getName()) + ": Building Weka attribute evaluator.", 0);
            evaluator.buildEvaluator(instances);
        }
        catch (UnassignedClassException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{this.getOperatorClassName(), e});
        }
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            try {
                double result = evaluator.evaluateAttribute(index++);
                weights.setWeight(attribute.getName(), result);
            }
            catch (Exception e) {
                LogService.logMessage(String.valueOf(this.getName()) + ": Cannot evaluate attribute '" + attribute.getName() + "', use unknown weight.", 4);
            }
        }
        return new IOObject[]{exampleSet, weights};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, AttributeWeights.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    private AttributeEvaluator getWekaAttributeEvaluator(String name, String[] parameters) throws OperatorException {
        String evaluatorName = null;
        int i = 0;
        while (i < WEKA_ATTRIBUTE_EVALUATORS.length) {
            if (WEKA_ATTRIBUTE_EVALUATORS[i].endsWith(name)) {
                evaluatorName = WEKA_ATTRIBUTE_EVALUATORS[i];
                break;
            }
            ++i;
        }
        AttributeEvaluator evaluator = null;
        try {
            evaluator = (AttributeEvaluator)ASEvaluation.forName(evaluatorName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{evaluatorName, e});
        }
        return evaluator;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            AttributeEvaluator evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), null);
            if (evaluator instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)evaluator).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        AttributeEvaluator evaluator = null;
        try {
            evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka attribute evaluator " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (evaluator != null && evaluator instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)evaluator, types, this.wekaParameters, false, null);
        }
        return types;
    }
}

