/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.KeepBest;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RedundanceRemoval;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureWeighting
extends FeatureOperator {
    private List<PopulationOperator> preOps = new LinkedList<PopulationOperator>();
    private List<PopulationOperator> postOps = new LinkedList<PopulationOperator>();
    private int generationsWOImp = 0;

    public abstract PopulationOperator getWeightingOperator(String var1);

    public FeatureWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.generationsWOImp = this.getParameterAsInt("generations_without_improval");
        this.preOps = new LinkedList<PopulationOperator>();
        this.preOps.add(new KeepBest(this.getParameterAsInt("keep_best")));
        this.preOps.add(this.getWeightingOperator(this.getParameterAsString("weights")));
        this.preOps.add(new RedundanceRemoval());
        this.postOps = new LinkedList<PopulationOperator>();
        return super.apply();
    }

    @Override
    public boolean solutionGoodEnough(Population population) {
        boolean stop = population.empty() || population.getGenerationsWithoutImproval() >= this.generationsWOImp;
        return stop;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet eSet) {
        return this.preOps;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet eSet) {
        return this.postOps;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("keep_best", "Keep the best n individuals in each generation.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("generations_without_improval", "Stop after n generations without improval of the performance.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("weights", "Use these weights for the creation of individuals in each generation.", true));
        return types;
    }
}

