/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.selection.AbstractGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.selection.SelectionCrossover;
import edu.udo.cs.yale.operator.features.weighting.VarianceAdaption;
import edu.udo.cs.yale.operator.features.weighting.WeightingCrossover;
import edu.udo.cs.yale.operator.features.weighting.WeightingMutation;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionaryWeighting
extends AbstractGeneticAlgorithm {
    private WeightingMutation weighting = null;

    public EvolutionaryWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        return new WeightingCrossover(this.getParameterAsInt("crossover_type"), this.getParameterAsDouble("p_crossover"), this.getRandom());
    }

    @Override
    public PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        this.weighting = new WeightingMutation(this.getParameterAsDouble("mutation_variance"), this.getParameterAsBoolean("bounded_mutation"), this.getRandom());
        return this.weighting;
    }

    @Override
    protected List<PopulationOperator> getPostProcessingPopulationOperators(ExampleSet eSet) throws UndefinedParameterError {
        LinkedList<PopulationOperator> otherPostOps = new LinkedList<PopulationOperator>();
        if (this.getParameterAsBoolean("1_5_rule")) {
            otherPostOps.add(new VarianceAdaption(this.weighting, eSet.getAttributes().size()));
        }
        return otherPostOps;
    }

    @Override
    public Population createInitialPopulation(ExampleSet exampleSet) throws UndefinedParameterError {
        int numberOfIndividuals = this.getParameterAsInt("population_size");
        Population initPop = new Population();
        int i = 0;
        while (i < numberOfIndividuals) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)exampleSet.clone());
            for (Attribute attribute : nes.getAttributes()) {
                nes.setWeight(attribute, this.getRandom().nextDouble());
            }
            initPop.add(new Individual(nes));
            ++i;
        }
        return initPop;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("mutation_variance", "The (initial) variance for each mutation.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("1_5_rule", "If set to true, the 1/5 rule for variance adaption is used.", true));
        types.add(new ParameterTypeBoolean("bounded_mutation", "If set to true, the weights are bounded between 0 and 1.", false));
        ParameterTypeDouble type = new ParameterTypeDouble("p_crossover", "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("crossover_type", "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        return types;
    }
}

