/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusBasedFeatureWeighting
extends Operator {
    private static String TARGET_VALUE_NAME = "class_to_characterize";
    private double epsilon = 0.001;

    public CorpusBasedFeatureWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet es = this.getInput(ExampleSet.class);
        String targetValue = this.getParameterAsString(TARGET_VALUE_NAME);
        double[] weights = this.generateWeightsForClass(es, targetValue);
        double maxWeight = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < weights.length) {
            if (weights[i] > maxWeight) {
                maxWeight = weights[i];
            }
            ++i;
        }
        maxWeight += this.epsilon;
        AttributeWeights attWeights = new AttributeWeights();
        int i2 = 0;
        for (Attribute attribute : es.getAttributes()) {
            if (weights[i2] > 0.0) {
                attWeights.setWeight(attribute.getName(), weights[i2] / maxWeight);
            } else {
                attWeights.setWeight(attribute.getName(), -1.0);
            }
            ++i2;
        }
        return new IOObject[]{es, attWeights};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, AttributeWeights.class};
    }

    private double[] generateWeightsForClass(ExampleSet es, String value) {
        double[] result = new double[es.getAttributes().size()];
        int i = 0;
        while (i < es.getAttributes().size()) {
            result[i] = 0.0;
            ++i;
        }
        Iterator er = es.iterator();
        Attribute labelAttribute = es.getAttributes().getLabel();
        while (er.hasNext()) {
            Example e = (Example)er.next();
            if (!e.getValueAsString(labelAttribute).equalsIgnoreCase(value)) continue;
            int index = 0;
            for (Attribute attribute : es.getAttributes()) {
                result[index] = result[index] + e.getValue(attribute);
                ++index;
            }
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(TARGET_VALUE_NAME, "The target class for which to find characteristic feature weights.", false));
        return types;
    }
}

