/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.operator.ContainerModel;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.transformation.ComponentWeightsCreatable;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentWeights
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{Model.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{Model.class, AttributeWeights.class};

    public ComponentWeights(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Model model = this.getInput(Model.class);
        if (model instanceof ContainerModel) {
            while (model instanceof ContainerModel) {
                model = ((ContainerModel)model).getModel(0);
            }
        } else {
            return new IOObject[]{model};
        }
        if (!(model instanceof ComponentWeightsCreatable)) {
            throw new OperatorException("Need model wich implements the ComponentWeightsCreatable interface:" + model.getClass().getName());
        }
        int component = this.getParameterAsInt("component_number");
        AttributeWeights weights = ((ComponentWeightsCreatable)((Object)model)).getWeightsOfComponent(component);
        return new IOObject[]{model, weights};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.add(new ParameterTypeInt("component_number", "Create the weights of this component.", 1, Integer.MAX_VALUE, 1));
        return list;
    }
}

