/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.weighting.FeatureWeighting;
import edu.udo.cs.yale.operator.features.weighting.SimpleWeighting;
import edu.udo.cs.yale.tools.LogService;

public class BackwardWeighting
extends FeatureWeighting {
    public BackwardWeighting(OperatorDescription description) {
        super(description);
    }

    public PopulationOperator getWeightingOperator(String parameter) {
        double[] weights = new double[]{1.0, 0.75, 0.5, 0.25};
        if (parameter != null && parameter.length() != 0) {
            try {
                String[] weightStrings = parameter.split(" ");
                weights = new double[weightStrings.length];
                int i = 0;
                while (i < weights.length) {
                    weights[i] = Double.parseDouble(weightStrings[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                LogService.logMessage("Could not create weights: " + e.getMessage() + "! Use standard weights.", 6);
                weights = new double[]{1.0, 0.75, 0.5, 0.25};
            }
        }
        return new SimpleWeighting(1.0, weights);
    }

    public Population createInitialPopulation(ExampleSet es) {
        Population initPop = new Population();
        AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
        for (Attribute attribute : es.getAttributes()) {
            nes.setWeight(attribute, 1.0);
        }
        initPop.add(new Individual(nes));
        return initPop;
    }
}

