/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.ContainerModel;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitSVMModel
extends Operator {
    public SplitSVMModel(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        boolean scaled;
        Model model = this.getInput(Model.class);
        while (model instanceof ContainerModel && ((ContainerModel)model).getNumberOfModels() > 0) {
            model = ((ContainerModel)model).getModel(0);
        }
        if (!(model instanceof JMySVMModel)) {
            throw new OperatorException("Expected JMySVMModel instead of: " + model.getClass().getName());
        }
        JMySVMModel svmmodel = (JMySVMModel)model;
        ExampleSet modelSet = svmmodel.getExampleSet();
        double[][] atts = modelSet.atts;
        int[][] index = modelSet.index;
        double[] y = modelSet.get_ys();
        double[] alphas = modelSet.get_alphas();
        boolean addalpha = this.getParameterAsBoolean("alpha");
        Map<Integer, ExampleSet.MeanVariance> meanvariances = modelSet.getMeanVariances();
        boolean bl = scaled = meanvariances != null;
        if (meanvariances != null) {
            scaled = !meanvariances.isEmpty();
        }
        int dim = modelSet.get_dim();
        int size = modelSet.count_examples();
        Attribute label = AttributeFactory.createAttribute("class", 1);
        StringTokenizer st = new StringTokenizer(this.getParameterAsString("classes"), " ");
        String pos = "p";
        String neg = "n";
        if (st.hasMoreTokens()) {
            pos = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            neg = st.nextToken();
        }
        label.getMapping().mapString(pos);
        label.getMapping().mapString(neg);
        Attribute alpha = AttributeFactory.createAttribute("alpha", 4);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int i = 0;
        while (i < dim) {
            attributes.add(AttributeFactory.createAttribute("att_" + (i + 1), 4));
            ++i;
        }
        if (addalpha) {
            attributes.add(alpha);
        }
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = new LinkedList<DoubleArrayDataRow>();
        int nr = dim + 1;
        if (addalpha) {
            ++nr;
        }
        int n = 0;
        while (n < size) {
            if (alphas[n] != 0.0) {
                double[] samples = new double[nr];
                int i2 = 0;
                while (i2 < dim) {
                    samples[i2] = 0.0;
                    ++i2;
                }
                i2 = 0;
                while (i2 < atts[n].length) {
                    samples[index[n][i2]] = atts[n][i2];
                    ++i2;
                }
                if (scaled) {
                    i2 = 0;
                    while (i2 < dim) {
                        ExampleSet.MeanVariance meanvariance = meanvariances.get(i2);
                        if (meanvariance != null) {
                            samples[i2] = samples[i2] * Math.sqrt(meanvariance.getVariance()) + meanvariance.getMean();
                        }
                        ++i2;
                    }
                }
                if (addalpha) {
                    samples[nr - 2] = alphas[n];
                }
                samples[nr - 1] = y[n] == 1.0 ? (double)label.getMapping().getPositiveIndex() : (double)label.getMapping().getNegativeIndex();
                data.add(new DoubleArrayDataRow(samples));
            }
            ++n;
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        edu.udo.cs.yale.example.ExampleSet svSet = null;
        svSet = table.createExampleSet(label);
        svSet.recalculateAllAttributeStatistics();
        SVMInterface svm = svmmodel.createSVM();
        svm.init(svmmodel.getKernel(), svmmodel.getExampleSet());
        double[] weights = svm.getWeights();
        AttributeWeights attweights = new AttributeWeights();
        int w = 0;
        for (Attribute attribute : svSet.getAttributes()) {
            attweights.setWeight(attribute.getName(), weights[w++]);
        }
        return new IOObject[]{svSet, attweights};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{edu.udo.cs.yale.example.ExampleSet.class, AttributeWeights.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("alpha", "Add the alpha values as an attribute.", false));
        types.add(new ParameterTypeString("classes", "The string representation of the classes. Note: Specify the negative class first!", "negative positive"));
        return types;
    }
}

