/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.math.som.KohonenNet;
import edu.udo.cs.yale.tools.math.som.RandomDataContainer;
import edu.udo.cs.yale.tools.math.som.RitterAdaption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOMDimensionalityReduction
extends Operator {
    private KohonenNet net;

    public SOMDimensionalityReduction(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int trainingRounds = this.getParameterAsInt("training_rounds");
        int netSize = this.getParameterAsInt("net_size");
        int dimensions = this.getParameterAsInt("number_of_dimensions");
        double learningRateStart = this.getParameterAsDouble("learning_rate_start");
        double learningRateEnd = this.getParameterAsDouble("learning_rate_end");
        double adaptionRadiusStart = this.getParameterAsDouble("adaption_radius_start");
        double adaptionRadiusEnd = this.getParameterAsDouble("adaption_radius_end");
        if (learningRateStart < learningRateEnd) {
            throw new UserError((Operator)this, 116, "learning_rate_start", (Object)("Learning rate at first round must be greater than in last round: (" + learningRateEnd + ")"));
        }
        if (adaptionRadiusStart < adaptionRadiusEnd) {
            throw new UserError((Operator)this, 116, "adaption_radius_start", (Object)("Adaption radius at first round must be greater than in last round: (" + adaptionRadiusEnd + ")"));
        }
        this.prepareSOM(exampleSet, dimensions, netSize, trainingRounds, learningRateStart, learningRateEnd, adaptionRadiusStart, adaptionRadiusEnd);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int i = 0;
        while (i < dimensions) {
            attributes.add(AttributeFactory.createAttribute("SOM_" + i, 2));
            ++i;
        }
        Iterator<AttributeRole> s = exampleSet.getAttributes().specialAttributes();
        HashMap<Attribute, String> newSpecialAttributes = new HashMap<Attribute, String>();
        while (s.hasNext()) {
            AttributeRole role = s.next();
            Attribute specialAttribute = role.getAttribute();
            Attribute newAttribute = (Attribute)specialAttribute.clone();
            attributes.add(newAttribute);
            newSpecialAttributes.put(newAttribute, role.getSpecialName());
        }
        MemoryExampleTable newDataTable = new MemoryExampleTable(attributes);
        for (Example currentExample : exampleSet) {
            int[] coords = this.net.apply(this.getDoubleArrayFromExample(currentExample));
            double[] exampleData = new double[attributes.size()];
            int i2 = 0;
            while (i2 < dimensions) {
                exampleData[i2] = coords[i2];
                ++i2;
            }
            s = exampleSet.getAttributes().specialAttributes();
            i2 = dimensions;
            while (s.hasNext()) {
                exampleData[i2++] = currentExample.getValue(s.next().getAttribute());
            }
            DoubleArrayDataRow newRow = new DoubleArrayDataRow(exampleData);
            newDataTable.addDataRow(newRow);
            this.checkForStop();
        }
        ExampleSet newExampleSet = newDataTable.createExampleSet(newSpecialAttributes);
        return new IOObject[]{newExampleSet};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSOM(ExampleSet exampleSet, int netDimensions, int netSize, int trainingRounds, double learningRateStart, double learningRateEnd, double adaptionRadiusStart, double adaptionRadiusEnd) {
        int dataDimension;
        RandomDataContainer data = new RandomDataContainer();
        ExampleSet exampleSet2 = exampleSet;
        synchronized (exampleSet2) {
            Iterator iterator = exampleSet.iterator();
            dataDimension = exampleSet.getAttributes().size();
            while (iterator.hasNext()) {
                data.addData(this.getDoubleArrayFromExample((Example)iterator.next()));
            }
        }
        this.net = new KohonenNet(data);
        RitterAdaption adaptionFunction = new RitterAdaption();
        adaptionFunction.setAdaptionRadiusStart(adaptionRadiusStart);
        adaptionFunction.setAdaptionRadiusEnd(adaptionRadiusEnd);
        adaptionFunction.setLearnRateStart(learningRateStart);
        adaptionFunction.setLearnRateEnd(learningRateEnd);
        this.net.setAdaptionFunction(adaptionFunction);
        int[] dimensions = new int[netDimensions];
        int i = 0;
        while (i < netDimensions) {
            dimensions[i] = netSize;
            ++i;
        }
        this.net.init(dataDimension, dimensions, false);
        this.net.setTrainingRounds(trainingRounds);
        this.net.train();
    }

    private double[] getDoubleArrayFromExample(Example example) {
        double[] doubleRow = new double[example.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            doubleRow[i++] = example.getValue(attribute);
        }
        return doubleRow;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_dimensions", "Defines the number of dimensions, the data shall be reduced.", 1, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("net_size", "Defines the size of the SOM net, by setting the length of every edge of the net.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("training_rounds", "Defines the number of trainnig rounds", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("learning_rate_start", "Defines the strength of an adaption in the first round. The strength will decrease every round until it reaches the learning_rate_end in the last round.", 0.0, Double.POSITIVE_INFINITY, 0.8));
        types.add(new ParameterTypeDouble("learning_rate_end", "Defines the strength of an adaption in the last round. The strength will decrease to this value in last round, beginning with learning_rate_start in the first round.", 0.0, Double.POSITIVE_INFINITY, 0.01));
        types.add(new ParameterTypeDouble("adaption_radius_start", "Defines the radius of the sphere around an stimulus, within an adaption occoures. This radius decreases every round, starting by adaption_radius_start in first round, to adaption_radius_end in last round.", 0.0, Double.POSITIVE_INFINITY, 10.0));
        types.add(new ParameterTypeDouble("adaption_radius_end", "Defines the radius of the sphere around an stimulus, within an adaption occoures. This radius decreases every round, starting by adaption_radius_start in first round, to adaption_radius_end in last round.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

