/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.List;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalComponentsTransformation
extends Operator {
    public PrincipalComponentsTransformation(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        PrincipalComponents transformation = new PrincipalComponents();
        transformation.setNormalize(false);
        transformation.setVarianceCovered(this.getParameterAsDouble("min_variance_coverage"));
        LogService.logMessage(String.valueOf(this.getName()) + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "PCAInstances", 0);
        try {
            LogService.logMessage(String.valueOf(this.getName()) + ": Building principal components.", 0);
            transformation.buildEvaluator(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{"PrincipalComponents", e});
        }
        ExampleSet result = null;
        try {
            Instances transformed = transformation.transformedData();
            result = WekaTools.toYaleExampleSet(transformed, "pc");
        }
        catch (Exception e) {
            throw new UserError((Operator)this, 905, "Principal Components Transformation", (Object)("Cannot convert to principal components (" + e.getMessage() + ")"));
        }
        return new IOObject[]{result};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("min_variance_coverage", "The minimum variance to cover in the original data to determine the number of principal components.", 0.0, 1.0, 0.95);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

