/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.AbstractModel;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.transformation.ComponentWeightsCreatable;
import edu.udo.cs.yale.operator.features.transformation.Eigenvector;
import edu.udo.cs.yale.operator.features.transformation.EigenvectorModelVisualization;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PCAModel
extends AbstractModel
implements ComponentWeightsCreatable {
    private List<Eigenvector> eigenVectors;
    private double[] means;
    private String[] attributeNames;
    private boolean manualNumber;
    private int numberOfComponents;
    private double varianceThreshold;
    private double[] variances;
    private double[] cumulativeVariance;
    private boolean keepAttributes = false;

    public PCAModel() {
        this.means = new double[0];
        this.attributeNames = new String[0];
        this.variances = new double[0];
        this.cumulativeVariance = new double[0];
        this.eigenVectors = new ArrayList<Eigenvector>();
    }

    public PCAModel(ExampleSet eSet, double[] eigenvalues, double[][] eigenvectors) {
        this.attributeNames = new String[eSet.getAttributes().size()];
        this.means = new double[eSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : eSet.getAttributes()) {
            this.attributeNames[counter] = attribute.getName();
            this.means[counter] = ((NumericalAttributeStatistics)attribute.getStatistics()).getAverage();
            ++counter;
        }
        this.eigenVectors = new ArrayList<Eigenvector>(eigenvalues.length);
        int i = 0;
        while (i < eigenvalues.length) {
            this.eigenVectors.add(new Eigenvector(eigenvectors[i], eigenvalues[i]));
            ++i;
        }
        Collections.sort(this.eigenVectors);
        this.calculateCumulativeVariance();
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public double[] getMeans() {
        return this.means;
    }

    public double getMean(int index) {
        return this.means[index];
    }

    public double getVariance(int index) {
        return this.variances[index];
    }

    public double getCumulativeVariance(int index) {
        return this.cumulativeVariance[index];
    }

    public double getEigenvalue(int index) {
        return this.eigenVectors.get(index).getEigenvalue();
    }

    public double[] getEigenvector(int index) {
        return this.eigenVectors.get(index).getEigenvector();
    }

    public double getVarianceThreshold() {
        return this.varianceThreshold;
    }

    public int getMaximumNumberOfComponents() {
        return this.attributeNames.length;
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public void setVarianceThreshold(double threshold) {
        this.manualNumber = false;
        this.varianceThreshold = threshold;
        this.numberOfComponents = -1;
    }

    public void setNumberOfComponents(int numberOfComponents) {
        this.varianceThreshold = 0.95;
        this.manualNumber = true;
        this.numberOfComponents = numberOfComponents;
    }

    public void apply(ExampleSet exampleSet) throws OperatorException {
        Example example;
        exampleSet.recalculateAllAttributeStatistics();
        if (this.attributeNames.length != exampleSet.getAttributes().size()) {
            throw new OperatorException("The ExampleSet must have " + this.attributeNames.length + " attributes!");
        }
        double[][] data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        boolean haslabel = exampleSet.getAttributes().getLabel() != null;
        boolean haspredlabel = exampleSet.getAttributes().getPredictedLabel() != null;
        double[] labelvalues = new double[]{};
        double[] predvalues = new double[]{};
        if (haslabel) {
            labelvalues = new double[exampleSet.size()];
        }
        if (haspredlabel) {
            predvalues = new double[exampleSet.size()];
        }
        Iterator reader = exampleSet.iterator();
        int sample = 0;
        while (sample < exampleSet.size()) {
            example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : example.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - this.means[d];
                if (haslabel) {
                    labelvalues[sample] = example.getValue(example.getAttributes().getLabel());
                }
                if (haspredlabel) {
                    predvalues[sample] = example.getValue(example.getAttributes().getPredictedLabel());
                }
                ++d;
            }
            ++sample;
        }
        Matrix dataMatrix = new Matrix(data);
        double[][] values = new double[this.eigenVectors.size()][this.attributeNames.length];
        int counter = 0;
        for (Eigenvector ev : this.eigenVectors) {
            values[counter++] = ev.getEigenvector();
        }
        Matrix eigenvectorMatrix = new Matrix(values);
        Matrix finaldataMatrix = dataMatrix.times(eigenvectorMatrix);
        int components = -1;
        if (this.manualNumber) {
            components = this.numberOfComponents;
        } else if (this.varianceThreshold == 0.0) {
            components = -1;
        } else {
            components = 0;
            while (this.cumulativeVariance[components] < this.varianceThreshold) {
                ++components;
            }
            if (++components == this.eigenVectors.size()) {
                --components;
            }
        }
        if (components == -1) {
            components = exampleSet.getAttributes().size();
        }
        LogService.logMessage("Number of components: " + components, 2);
        finaldataMatrix = new Matrix(finaldataMatrix.getArray(), exampleSet.size(), components);
        double[][] finaldata = finaldataMatrix.getArray();
        if (!this.keepAttributes) {
            exampleSet.getAttributes().clearRegular();
        }
        LogService.logMessage("Adding new the derived features...", 2);
        Attribute[] pcatts = new Attribute[components];
        int i = 0;
        while (i < components) {
            pcatts[i] = AttributeFactory.createAttribute("pc_" + (i + 1), 4);
            exampleSet.getExampleTable().addAttribute(pcatts[i]);
            exampleSet.getAttributes().addRegular(pcatts[i]);
            ++i;
        }
        reader = exampleSet.iterator();
        int sample2 = 0;
        while (sample2 < exampleSet.size()) {
            example = (Example)reader.next();
            int d = 0;
            while (d < components) {
                example.setValue(pcatts[d], finaldata[sample2][d]);
                ++d;
            }
            ++sample2;
        }
    }

    private void calculateCumulativeVariance() {
        double sumvariance = 0.0;
        for (Eigenvector ev : this.eigenVectors) {
            sumvariance += ev.getEigenvalue();
        }
        this.variances = new double[this.eigenVectors.size()];
        this.cumulativeVariance = new double[this.variances.length];
        double cumulative = 0.0;
        int counter = 0;
        for (Eigenvector ev : this.eigenVectors) {
            double proportion;
            this.variances[counter] = proportion = ev.getEigenvalue() / sumvariance;
            this.cumulativeVariance[counter] = cumulative += proportion;
            ++counter;
        }
    }

    public void setParameter(String name, Object object) throws OperatorException {
        if (name.equals("variance_threshold")) {
            String value = (String)object;
            try {
                this.setVarianceThreshold(Double.parseDouble(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("number_of_components")) {
            String value = (String)object;
            try {
                this.setNumberOfComponents(Integer.parseInt(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("keep_attributes")) {
            String value = (String)object;
            this.keepAttributes = false;
            if (value.equals("true")) {
                this.keepAttributes = true;
            }
        } else {
            super.setParameter(name, object);
        }
    }

    public AttributeWeights getWeightsOfComponent(int component) throws OperatorException {
        if (component < 1) {
            component = 1;
        }
        if (component > this.attributeNames.length) {
            LogService.logMessage("Creating weights of component " + this.attributeNames.length + "!", 4);
            component = this.attributeNames.length;
        }
        AttributeWeights weights = new AttributeWeights();
        int i = 0;
        while (i < this.attributeNames.length) {
            weights.setWeight(this.attributeNames[i], this.eigenVectors.get(i).getEigenvector()[component - 1]);
            ++i;
        }
        return weights;
    }

    public Component getVisualizationComponent(IOContainer container) {
        return new EigenvectorModelVisualization(this.getName(), this.attributeNames, this.cumulativeVariance, this.eigenVectors, this.manualNumber, this.numberOfComponents, this.varianceThreshold).getVisualizationComponent(container);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(Tools.getLineSeparator()) + "Principal Components:" + Tools.getLineSeparator());
        if (this.manualNumber) {
            result.append("Number of Components: " + this.numberOfComponents + Tools.getLineSeparator());
        } else {
            result.append("Variance Threshold: " + this.varianceThreshold + Tools.getLineSeparator());
        }
        int i = 0;
        while (i < this.eigenVectors.size()) {
            result.append("PC " + (i + 1) + ": ");
            int j = 0;
            while (j < this.attributeNames.length) {
                double value = this.eigenVectors.get(j).getEigenvector()[i];
                if (value > 0.0) {
                    result.append(" + ");
                } else {
                    result.append(" - ");
                }
                result.append(String.valueOf(Tools.formatNumber(Math.abs(value))) + " * " + this.attributeNames[j]);
                ++j;
            }
            result.append(Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }
}

