/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.features.transformation.PCAModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCA
extends Operator {
    public static final String[] REDUCTION_METHODS = new String[]{"none", "keep variance", "fixed number"};
    public static final int REDUCTION_NONE = 0;
    public static final int REDUCTION_VARIANCE = 1;
    public static final int REDUCTION_FIXED = 2;
    private double[][] data;
    private Matrix covarianceMatrix;
    private double[][] covarianceMatrixEntries;
    private double[] eigenvalues;
    private Matrix eigenvectorMatrix;
    private double[][] eigenvectors;

    public PCA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            throw new UserError((Operator)this, 104, "PCA", (Object)attribute.getName());
        }
        this.data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        Iterator reader = exampleSet.iterator();
        int sample = 0;
        while (sample < exampleSet.size()) {
            Example example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                this.data[sample][d++] = example.getValue(attribute) - ((NumericalAttributeStatistics)attribute.getStatistics()).getAverage();
            }
            ++sample;
        }
        LogService.logMessage("Creating the covariance matrix...", 2);
        this.covarianceMatrixEntries = new double[exampleSet.getAttributes().size()][exampleSet.getAttributes().size()];
        int i = 0;
        while (i < exampleSet.getAttributes().size()) {
            int j = 0;
            while (j < exampleSet.getAttributes().size()) {
                double covariance = this.getCovarianz(i, j);
                if (i != j) {
                    this.covarianceMatrixEntries[i][j] = covariance;
                    this.covarianceMatrixEntries[j][i] = covariance;
                } else {
                    this.covarianceMatrixEntries[i][j] = covariance;
                }
                ++j;
            }
            this.checkForStop();
            ++i;
        }
        this.covarianceMatrix = new Matrix(this.covarianceMatrixEntries);
        LogService.logMessage("Performing the eigenvalue decomposition...", 2);
        EigenvalueDecomposition eigenvalueDecomposition = this.covarianceMatrix.eig();
        this.eigenvalues = eigenvalueDecomposition.getRealEigenvalues();
        this.eigenvectorMatrix = eigenvalueDecomposition.getV();
        this.eigenvectors = this.eigenvectorMatrix.getArray();
        PCAModel model = new PCAModel(exampleSet, this.eigenvalues, this.eigenvectors);
        int reductionType = this.getParameterAsInt("dimensionality_reduction");
        switch (reductionType) {
            case 0: {
                model.setNumberOfComponents(exampleSet.getAttributes().size());
                break;
            }
            case 1: {
                model.setVarianceThreshold(this.getParameterAsDouble("variance_threshold"));
                break;
            }
            case 2: {
                model.setNumberOfComponents(this.getParameterAsInt("number_of_components"));
            }
        }
        return new IOObject[]{exampleSet, model};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    private double getCovarianz(int dim1, int dim2) {
        double covariance = 0.0;
        int sample = 0;
        while (sample < this.data.length) {
            covariance += this.data[sample][dim1] * this.data[sample][dim2];
            ++sample;
        }
        return covariance /= (double)(this.data.length - 1);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble("variance_threshold", "Keep the all components with a cumulative variance smaller than the given threshold.", 0.0, 1.0, 0.95);
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeCategory("dimensionality_reduction", "Indicates which type of dimensionality reduction should be applied", REDUCTION_METHODS, 1);
        list.add(type);
        type = new ParameterTypeInt("number_of_components", "Keep this number of components. If '-1' then keep all components.'", -1, Integer.MAX_VALUE, -1);
        list.add(type);
        return list;
    }
}

