/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperplaneProjection
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};
    private int numberOfSamples;
    private int numberOfAttributes;
    private double[][] samples;
    private double[] weights;
    private double bias;

    public HyperplaneProjection(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Example example;
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        AttributeWeights attributeWeights = this.getInput(AttributeWeights.class);
        this.bias = this.getParameterAsDouble("bias");
        this.numberOfSamples = exampleSet.size();
        this.numberOfAttributes = exampleSet.getAttributes().size();
        this.samples = new double[this.numberOfSamples][this.numberOfAttributes];
        this.weights = new double[this.numberOfAttributes];
        int w = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.weights[w++] = attributeWeights.getWeight(attribute.getName());
        }
        Iterator reader = exampleSet.iterator();
        int sample = 0;
        while (sample < this.numberOfSamples) {
            example = (Example)reader.next();
            int i = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                this.samples[sample][i++] = example.getValue(attribute);
            }
            ++sample;
        }
        this.calculateHyperplaneSamples();
        reader = exampleSet.iterator();
        sample = 0;
        while (sample < exampleSet.size()) {
            example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                example.setValue(attribute, this.samples[sample][d++]);
            }
            ++sample;
        }
        exampleSet.recalculateAllAttributeStatistics();
        return new IOObject[]{exampleSet};
    }

    private void calculateHyperplaneSamples() {
        double ww = 0.0;
        int i = 0;
        while (i < this.weights.length) {
            ww += this.weights[i] * this.weights[i];
            ++i;
        }
        int s = 0;
        while (s < this.numberOfSamples) {
            double wx = 0.0;
            int i2 = 0;
            while (i2 < this.numberOfAttributes) {
                wx += this.weights[i2] * this.samples[s][i2];
                ++i2;
            }
            double t = (-1.0 * this.bias - wx) / ww;
            i2 = 0;
            while (i2 < this.numberOfAttributes) {
                this.samples[s][i2] = this.samples[s][i2] + t * this.weights[i2];
                ++i2;
            }
            ++s;
        }
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("bias", "The bias of the hyperplane", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        list.add(type);
        return list;
    }
}

