/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.features.transformation.GHAModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHA
extends Operator {
    private double learningRate;
    private int numberOfComponents;
    private int numberOfIterations;
    private double[] means;
    private double[][] data;
    private Matrix W;
    private RandomGenerator random;

    public GHA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        this.random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        exampleSet.recalculateAllAttributeStatistics();
        this.means = new double[exampleSet.getAttributes().size()];
        int a = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal()) {
                throw new UserError((Operator)this, 104, "GHA", (Object)attribute.getName());
            }
            this.means[a] = ((NumericalAttributeStatistics)attribute.getStatistics()).getAverage();
            ++a;
        }
        LogService.logMessage("Initialising the weight matrix...", 2);
        this.data = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        Iterator reader = exampleSet.iterator();
        int sample = 0;
        while (sample < exampleSet.size()) {
            Example example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                this.data[sample][d] = example.getValue(attribute) - this.means[d];
                ++d;
            }
            this.checkForStop();
            ++sample;
        }
        this.learningRate = this.getParameterAsDouble("learning_rate");
        this.numberOfComponents = this.getParameterAsInt("number_of_components");
        if (this.numberOfComponents < 0) {
            this.numberOfComponents = exampleSet.getAttributes().size();
        }
        this.numberOfIterations = this.getParameterAsInt("number_of_iterations");
        double[][] randomMatrix = new double[this.numberOfComponents][exampleSet.getAttributes().size()];
        int i = 0;
        while (i < randomMatrix.length) {
            int j = 0;
            while (j < randomMatrix[i].length) {
                randomMatrix[i][j] = this.random.nextDouble();
                ++j;
            }
            ++i;
        }
        this.W = new Matrix(randomMatrix);
        this.W.timesEquals(0.1);
        LogService.logMessage("Training with learning rate: " + this.learningRate, 2);
        this.train();
        LogService.logMessage("Creating the model...", 2);
        double[][] covarianceMatrixEntries = new double[exampleSet.getAttributes().size()][exampleSet.getAttributes().size()];
        int i2 = 0;
        while (i2 < exampleSet.getAttributes().size()) {
            int j = 0;
            while (j < exampleSet.getAttributes().size()) {
                double covariance = this.getCovariance(i2, j);
                if (i2 != j) {
                    covarianceMatrixEntries[i2][j] = covariance;
                    covarianceMatrixEntries[j][i2] = covariance;
                } else {
                    covarianceMatrixEntries[i2][j] = covariance;
                }
                this.checkForStop();
                ++j;
            }
            ++i2;
        }
        Matrix covarianceMatrix = new Matrix(covarianceMatrixEntries);
        Matrix tmp = this.W.times(covarianceMatrix);
        double[][] weights = this.W.getArray();
        double[][] tmparray = tmp.getArray();
        double[] eigenvalues = new double[this.numberOfComponents];
        int i3 = 0;
        while (i3 < weights.length) {
            double nr = 0.0;
            eigenvalues[i3] = 0.0;
            int j = 0;
            while (j < weights[0].length) {
                tmparray[i3][j] = tmparray[i3][j] / weights[i3][j];
                if (tmparray[i3][j] > 0.0) {
                    nr += 1.0;
                    int n = i3;
                    eigenvalues[n] = eigenvalues[n] + tmparray[i3][j];
                }
                ++j;
            }
            nr = Math.max(nr, 1.0);
            eigenvalues[i3] = eigenvalues[i3] / nr;
            ++i3;
        }
        GHAModel model = new GHAModel(exampleSet, eigenvalues, this.W.getArray(), this.means);
        return new IOObject[]{exampleSet, model};
    }

    private double getCovariance(int dim1, int dim2) {
        double cov = 0.0;
        int sample = 0;
        while (sample < this.data.length) {
            cov += this.data[sample][dim1] * this.data[sample][dim2];
            ++sample;
        }
        return cov /= (double)(this.data.length - 1);
    }

    private void train() throws OperatorException {
        int iterlog = 1;
        while (this.numberOfIterations / iterlog > 10 && this.numberOfIterations / (iterlog * 10) >= 3) {
            iterlog *= 10;
        }
        int iter = 1;
        while (iter <= this.numberOfIterations) {
            if (iter % iterlog == 0) {
                LogService.logMessage("Iteration " + iter, 2);
            }
            int sample = (int)(this.random.nextDouble() * (double)this.data.length);
            Matrix x = new Matrix(this.data[sample], this.data[sample].length);
            Matrix y = this.W.times(x);
            double[][] yyT = y.times(y.transpose()).getArray();
            int row = 0;
            while (row < yyT.length) {
                int col = row + 1;
                while (col < yyT.length) {
                    yyT[row][col] = 0.0;
                    ++col;
                }
                ++row;
            }
            Matrix LT = new Matrix(yyT);
            Matrix tmp1 = y.times(x.transpose());
            Matrix tmp2 = LT.times(this.W);
            tmp1 = tmp1.minus(tmp2);
            tmp1.timesEquals(this.learningRate);
            this.W.plusEquals(tmp1);
            double[][] w = this.W.getArray();
            int i = 0;
            while (i < w.length) {
                int j = 0;
                while (j < w[0].length) {
                    if (Double.isInfinite(w[i][j]) || Double.isNaN(w[i][j])) {
                        throw new OperatorException("Lost convergence at iterator " + (iter + 1) + ". Lower learning rate?");
                    }
                    ++j;
                }
                ++i;
            }
            this.checkForStop();
            ++iter;
        }
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("number_of_components", "Number of components to compute. If '-1' nr of attributes is taken.'", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        list.add(type);
        type = new ParameterTypeInt("number_of_iterations", "Number of Iterations to apply the update rule.", 0, Integer.MAX_VALUE, 10);
        list.add(type);
        type = new ParameterTypeDouble("learning_rate", "The learning rate for GHA (small)", 0.0, Double.POSITIVE_INFINITY, 0.01);
        list.add(type);
        list.add(new ParameterTypeInt("local_random_seed", "The local random seed for this operator, uses global random number generator if -1.", -1, Integer.MAX_VALUE, -1));
        return list;
    }
}

