/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.mySVM.Examples.Example;
import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.ContainerModel;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Model;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.kernel.JMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionValueSeries
extends Operator {
    private double[] weights;
    private int[] attribute_index;
    private int number_of_samples;
    private int number_atts;
    private int nr_series;
    private int nr_attributes;
    private double[] labelvalues;
    private double[] predvalues;
    private double[][] samples;
    private double[][] fvalue_series;
    private ExampleSet trainSet;
    private ExampleSet modelSet;

    public FunctionValueSeries(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        int i;
        edu.udo.cs.yale.example.ExampleSet eSet = this.getInput(edu.udo.cs.yale.example.ExampleSet.class);
        boolean haslabel = eSet.getAttributes().getLabel() != null;
        boolean haspredlabel = eSet.getAttributes().getPredictedLabel() != null;
        this.number_of_samples = eSet.size();
        this.number_atts = eSet.getAttributes().size();
        this.labelvalues = new double[this.number_of_samples];
        this.predvalues = new double[this.number_of_samples];
        this.nr_attributes = this.getParameterAsInt("nr_attributes");
        this.nr_series = this.number_atts / this.nr_attributes;
        if (this.number_atts % this.nr_attributes > 0) {
            ++this.nr_series;
        }
        this.fvalue_series = new double[this.number_of_samples][this.nr_series];
        this.samples = new double[this.number_atts][this.number_of_samples];
        Iterator reader = eSet.iterator();
        int sample = 0;
        while (sample < this.number_of_samples) {
            edu.udo.cs.yale.example.Example example = (edu.udo.cs.yale.example.Example)reader.next();
            int d = 0;
            for (Attribute attribute : eSet.getAttributes()) {
                this.samples[d][sample] = example.getValue(attribute);
                ++d;
            }
            if (haslabel) {
                this.labelvalues[sample] = example.getValue(example.getAttributes().getLabel());
            }
            if (haspredlabel) {
                this.predvalues[sample] = example.getValue(example.getAttributes().getPredictedLabel());
            }
            ++sample;
        }
        this.attribute_index = new int[this.number_atts];
        int i2 = 0;
        while (i2 < this.attribute_index.length) {
            this.attribute_index[i2] = i2;
            ++i2;
        }
        Model model = this.getInput(Model.class);
        while (model instanceof ContainerModel && ((ContainerModel)model).getNumberOfModels() > 0) {
            model = ((ContainerModel)model).getModel(0);
        }
        if (!(model instanceof JMySVMModel)) {
            throw new OperatorException("Expected JMySVMModel instead of: " + model.getClass().getName());
        }
        JMySVMModel jmysvmmodel = (JMySVMModel)model;
        this.modelSet = jmysvmmodel.getExampleSet();
        this.trainSet = new ExampleSet(eSet, eSet.getAttributes().getLabel(), this.modelSet.getMeanVariances());
        SVMInterface svm = jmysvmmodel.createSVM();
        svm.init(jmysvmmodel.getKernel(), jmysvmmodel.getExampleSet());
        this.weights = svm.getWeights();
        this.orderWeights(this.weights);
        int d = 0;
        while (d < this.nr_series) {
            i = 0;
            while (i < this.number_of_samples) {
                this.fvalue_series[i][d] = 0.0;
                int[] index = new int[this.number_atts];
                int a = 0;
                while (a < this.number_atts) {
                    index[a] = a;
                    ++a;
                }
                Example svm_example = this.trainSet.get_example(i);
                double[] atts = svm_example.toDense(this.number_atts);
                int a2 = Math.min((d + 1) * this.nr_attributes, this.number_atts) - 1;
                while (a2 < this.number_atts) {
                    atts[this.attribute_index[a2]] = 0.0;
                    ++a2;
                }
                svm_example = new Example(index, atts);
                double the_sum = this.modelSet.get_b();
                double[] alphas = this.modelSet.get_alphas();
                int j = 0;
                while (j < this.modelSet.count_examples()) {
                    double alpha = alphas[j];
                    if (alpha != 0.0) {
                        int[] sv_index = new int[this.number_atts];
                        int a3 = 0;
                        while (a3 < this.number_atts) {
                            sv_index[a3] = a3;
                            ++a3;
                        }
                        double[] sv_att = this.modelSet.get_example(j).toDense(this.number_atts);
                        the_sum += alpha * jmysvmmodel.getKernel().calculate_K(sv_index, sv_att, svm_example.index, svm_example.att);
                    }
                    ++j;
                }
                this.fvalue_series[i][d] = the_sum;
                ++i;
            }
            ++d;
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        i = 0;
        while (i < this.nr_series) {
            attributes.add(AttributeFactory.createAttribute("fvalue_" + (i + 1), 4));
            ++i;
        }
        if (haslabel) {
            attributes.add(eSet.getAttributes().getLabel());
        }
        if (haspredlabel) {
            attributes.add(eSet.getAttributes().getPredictedLabel());
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = new LinkedList<DoubleArrayDataRow>();
        int nr = this.nr_series;
        if (haslabel) {
            ++nr;
        }
        if (haspredlabel) {
            ++nr;
        }
        int n = 0;
        while (n < this.number_of_samples) {
            double[] samples = new double[nr];
            System.arraycopy(this.fvalue_series[n], 0, samples, 0, this.nr_series);
            if (haslabel) {
                samples[this.nr_series] = this.labelvalues[n];
            }
            if (haspredlabel) {
                samples[nr - 1] = this.predvalues[n];
            }
            data.add(new DoubleArrayDataRow(samples));
            ++n;
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        edu.udo.cs.yale.example.ExampleSet resultSet = null;
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        specialMap.put(eSet.getAttributes().getLabel(), "label");
        specialMap.put(eSet.getAttributes().getPredictedLabel(), "prediction");
        resultSet = table.createExampleSet(specialMap);
        resultSet.recalculateAllAttributeStatistics();
        return new IOObject[]{resultSet};
    }

    public void orderWeights(double[] array, int links, int rechts) {
        int left = links;
        int right = rechts;
        double pivot = array[links + rechts >>> 1];
        pivot = Math.abs(pivot);
        while (true) {
            if (Math.abs(array[left]) > pivot) {
                ++left;
                continue;
            }
            while (Math.abs(array[right]) < pivot) {
                --right;
            }
            if (left <= right) {
                double temp = array[left];
                array[left] = array[right];
                array[right] = temp;
                temp = this.attribute_index[left];
                this.attribute_index[left] = this.attribute_index[right];
                this.attribute_index[right] = (int)temp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (links < right) {
            this.orderWeights(array, links, right);
        }
        if (left < rechts) {
            this.orderWeights(array, left, rechts);
        }
    }

    public void orderWeights(double[] weights) {
        this.orderWeights(weights, 0, weights.length - 1);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{edu.udo.cs.yale.example.ExampleSet.class, Model.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{edu.udo.cs.yale.example.ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("nr_attributes", "The number of attributes summarized in each iteration.", 1, Integer.MAX_VALUE, 1);
        types.add(type);
        return types;
    }
}

