/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.math.Complex;
import edu.udo.cs.yale.tools.math.FastFourierTransform;
import edu.udo.cs.yale.tools.math.Peak;
import edu.udo.cs.yale.tools.math.SpectrumFilter;
import java.util.LinkedList;

public class FourierTransform
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public FourierTransform(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int numberOfNewExamples = FastFourierTransform.getGreatestPowerOf2LessThan(exampleSet.size()) / 2;
        MemoryExampleTable exampleTable = new MemoryExampleTable(new LinkedList<Attribute>(), numberOfNewExamples);
        Attribute frequencyAttribute = AttributeFactory.createAttribute("frequency", 4);
        exampleTable.addAttribute(frequencyAttribute);
        DataRowReader drr = exampleTable.getDataRowReader();
        int k = 0;
        while (drr.hasNext()) {
            DataRow dataRow = (DataRow)drr.next();
            dataRow.set(frequencyAttribute, FastFourierTransform.convertFrequency(k++, numberOfNewExamples, exampleSet.size()));
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        attributes.add(frequencyAttribute);
        Attribute label = exampleSet.getAttributes().getLabel();
        FastFourierTransform fft = new FastFourierTransform(4);
        SpectrumFilter filter = new SpectrumFilter(0);
        for (Attribute current : exampleSet.getAttributes()) {
            if (current.isNominal()) continue;
            Complex[] result = fft.getFourierTransform(exampleSet, label, current);
            Peak[] spectrum = filter.filter(result, exampleSet.size());
            Attribute newAttribute = AttributeFactory.createAttribute("fft(" + current.getName() + ")", 4);
            exampleTable.addAttribute(newAttribute);
            attributes.add(newAttribute);
            this.fillTable(exampleTable, newAttribute, spectrum);
        }
        SimpleExampleSet resultSet = new SimpleExampleSet(exampleTable);
        return new IOObject[]{resultSet};
    }

    private void fillTable(ExampleTable table, Attribute attribute, Peak[] values) throws OperatorException {
        DataRowReader reader = table.getDataRowReader();
        int k = 0;
        while (reader.hasNext()) {
            DataRow dataRow = (DataRow)reader.next();
            dataRow.set(attribute, values[k++].getMagnitude());
            this.checkForStop();
        }
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }
}

