/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import Jama.Matrix;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.AbstractModel;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.features.transformation.ComponentWeightsCreatable;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;

public class FastICAModel
extends AbstractModel
implements ComponentWeightsCreatable {
    private double[] means;
    private boolean rowNorm;
    private int numberOfComponents;
    private Matrix K;
    private Matrix W;
    private Matrix A;
    private String[] attributeNames;
    private int numberOfSamples;
    private int numberOfAttributes;
    private boolean keepAttributes = false;

    public FastICAModel() {
        this.attributeNames = new String[0];
        this.numberOfComponents = 0;
        this.means = new double[0];
        this.rowNorm = false;
        this.K = new Matrix(0, 0);
        this.W = new Matrix(0, 0);
        this.A = new Matrix(0, 0);
    }

    public FastICAModel(String[] attributeNames, int numberOfComponents, double[] means, boolean rowNorm, Matrix K, Matrix W, Matrix A) {
        this.attributeNames = attributeNames;
        this.numberOfComponents = numberOfComponents;
        this.means = means;
        this.rowNorm = rowNorm;
        this.K = K;
        this.W = W;
        this.A = A;
    }

    public void apply(ExampleSet testSet) throws OperatorException {
        Example example;
        testSet.recalculateAllAttributeStatistics();
        this.numberOfSamples = testSet.size();
        this.numberOfAttributes = testSet.getAttributes().size();
        if (this.numberOfAttributes != this.means.length) {
            throw new UserError(null, 133, (Object)this.means.length, (Object)this.numberOfAttributes);
        }
        for (Attribute attribute : testSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            throw new UserError(null, 104, new Object[]{"FastICA", attribute.getName()});
        }
        double[][] data = new double[this.numberOfSamples][this.numberOfAttributes];
        Iterator reader = testSet.iterator();
        int sample = 0;
        while (sample < this.numberOfSamples) {
            example = (Example)reader.next();
            int d = 0;
            for (Attribute attribute : testSet.getAttributes()) {
                data[sample][d] = example.getValue(attribute) - this.means[d];
                ++d;
            }
            ++sample;
        }
        if (this.rowNorm) {
            LogService.logMessage("Scaling the data now.", 2);
            int row = 0;
            while (row < this.numberOfSamples) {
                double rmsRow = 0.0;
                int d = 0;
                while (d < this.numberOfAttributes) {
                    rmsRow += data[row][d] * data[row][d];
                    ++d;
                }
                rmsRow = Math.sqrt(rmsRow) / (double)Math.max(1, this.numberOfAttributes - 1);
                d = 0;
                while (d < this.numberOfAttributes) {
                    data[row][d] = data[row][d] / rmsRow;
                    ++d;
                }
                ++row;
            }
        }
        Matrix X = new Matrix(data);
        Matrix S = X.times(this.K).times(this.W);
        if (!this.keepAttributes) {
            testSet.getAttributes().clearRegular();
        }
        Attribute[] icAttributes = new Attribute[this.numberOfComponents];
        int i = 0;
        while (i < this.numberOfComponents) {
            icAttributes[i] = AttributeFactory.createAttribute("ic_" + (i + 1), 4);
            testSet.getExampleTable().addAttribute(icAttributes[i]);
            testSet.getAttributes().addRegular(icAttributes[i]);
            ++i;
        }
        double[][] finaldata = S.getArray();
        reader = testSet.iterator();
        int sample2 = 0;
        while (sample2 < testSet.size()) {
            example = (Example)reader.next();
            int d = 0;
            while (d < this.numberOfComponents) {
                example.setValue(icAttributes[d], finaldata[sample2][d]);
                ++d;
            }
            ++sample2;
        }
    }

    public void setNumberOfComponents(int number) {
        this.numberOfComponents = number;
    }

    public void setParameter(String name, Object object) throws OperatorException {
        if (name.equals("number_of_components")) {
            String value = (String)object;
            try {
                this.setNumberOfComponents(Integer.parseInt(value));
            }
            catch (NumberFormatException error) {
                super.setParameter(name, value);
            }
        } else if (name.equals("keep_attributes")) {
            String value = (String)object;
            this.keepAttributes = false;
            if (value.equals("true")) {
                this.keepAttributes = true;
            }
        } else {
            super.setParameter(name, object);
        }
    }

    public AttributeWeights getWeightsOfComponent(int component) throws OperatorException {
        if (component < 1) {
            component = 1;
        }
        if (component > this.numberOfComponents) {
            LogService.logMessage("Creating weights of component " + this.numberOfComponents + "!", 4);
            component = this.numberOfComponents;
        }
        AttributeWeights attweights = new AttributeWeights();
        int i = 0;
        while (i < this.attributeNames.length) {
            attweights.setWeight(this.attributeNames[i], this.A.get(component - 1, i));
            ++i;
        }
        return attweights;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Number of Components: " + this.numberOfComponents + Tools.getLineSeparator());
        result.append("Resulting attribute weights (from first component):" + Tools.getLineSeparator());
        int i = 0;
        while (i < this.attributeNames.length) {
            result.append(String.valueOf(this.attributeNames[i]) + ": " + Tools.formatNumber(this.A.get(1, i)) + Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }
}

