/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.transformation;

import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.datatable.SimpleDataTableRow;
import edu.udo.cs.yale.gui.plotter.ScatterPlotter;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.features.transformation.ComponentVector;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EigenvectorModelVisualization
implements ActionListener {
    private Component[] visualizationComponent;
    private JPanel visualizationPanel;
    private JRadioButton eigenValueTableButton;
    private JRadioButton eigenVectorTableButton;
    private JRadioButton cumulativeVariancePlotButton;
    private int lastSelectedIndex;
    private String[] attributeNames;
    private double[] cumulativeVariance;
    private List<? extends ComponentVector> eigenVectors;
    private boolean manualNumber;
    private int numberOfComponents;
    private String name;
    private double varianceThreshold;

    public EigenvectorModelVisualization(String name, String[] attributeNames, double[] cumulativeVariances, List<? extends ComponentVector> eigenVectors, boolean manualNumber, int numberOfComponents, double varianceThreshold) {
        this.name = name;
        this.attributeNames = attributeNames;
        this.cumulativeVariance = cumulativeVariances;
        this.eigenVectors = eigenVectors;
        this.manualNumber = manualNumber;
        this.numberOfComponents = numberOfComponents;
        this.varianceThreshold = varianceThreshold;
    }

    private Component getEigenvalueTable() {
        double varianceSum = 0.0;
        for (ComponentVector componentVector : this.eigenVectors) {
            varianceSum += componentVector.getEigenvalue();
        }
        ExtendedJTable extendedJTable = new ExtendedJTable();
        private class EigenvalueModel
        extends AbstractTableModel {
            private static final long serialVersionUID = -9026248524043239399L;
            private double varianceSum;

            public EigenvalueModel(double varianceSum) {
                this.varianceSum = varianceSum;
            }

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return EigenvectorModelVisualization.this.eigenVectors.size();
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return "PC " + (rowIndex + 1);
                    }
                    case 1: {
                        return Tools.formatNumber(Math.sqrt(((ComponentVector)EigenvectorModelVisualization.this.eigenVectors.get(rowIndex)).getEigenvalue()));
                    }
                    case 2: {
                        return Tools.formatNumber(((ComponentVector)EigenvectorModelVisualization.this.eigenVectors.get(rowIndex)).getEigenvalue() / this.varianceSum);
                    }
                    case 3: {
                        return Tools.formatNumber(EigenvectorModelVisualization.this.cumulativeVariance[rowIndex]);
                    }
                }
                return "unknown";
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Component";
                    }
                    case 1: {
                        return "Standard Deviation";
                    }
                    case 2: {
                        return "Proportion of Variance";
                    }
                    case 3: {
                        return "Cumulative Variance";
                    }
                }
                return "unknown";
            }
        }
        ((JTable)extendedJTable).setModel(new EigenvalueModel(varianceSum));
        StringBuffer result = new StringBuffer("<html><h1>" + this.name + " - Eigenvalues" + "</h1>");
        if (this.manualNumber) {
            result.append("Number of Components: " + this.numberOfComponents + "<br><br>");
        } else {
            result.append("Variance Threshold: " + this.varianceThreshold + "<br></html>");
        }
        JLabel headerLabel = new JLabel(result.toString());
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.insets = new Insets(11, 11, 11, 11);
        c.gridwidth = 0;
        layout.setConstraints(headerLabel, c);
        panel.add(headerLabel);
        JScrollPane tablePane = new JScrollPane(extendedJTable);
        c.weighty = 1.0;
        layout.setConstraints(tablePane, c);
        panel.add(tablePane);
        return panel;
    }

    private Component getEigenvectorTable() {
        ExtendedJTable eigenvalueTable = new ExtendedJTable();
        private class EigenvectorModel
        extends AbstractTableModel {
            private static final long serialVersionUID = -9026248524043239399L;

            EigenvectorModel() {
            }

            public int getColumnCount() {
                return EigenvectorModelVisualization.this.eigenVectors.size() + 1;
            }

            public int getRowCount() {
                return EigenvectorModelVisualization.this.numberOfComponents;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return EigenvectorModelVisualization.this.attributeNames[rowIndex];
                }
                return Tools.formatNumber(((ComponentVector)EigenvectorModelVisualization.this.eigenVectors.get(rowIndex)).getVector()[columnIndex - 1]);
            }

            public String getColumnName(int column) {
                if (column == 0) {
                    return "Attribute";
                }
                return "PC " + column;
            }
        }
        ((JTable)eigenvalueTable).setModel(new EigenvectorModel());
        StringBuffer result = new StringBuffer("<html><h1>" + this.name + " - Eigenvectors" + "</h1>");
        if (this.manualNumber) {
            result.append("Number of Components: " + this.numberOfComponents + "<br><br>");
        } else {
            result.append("Variance Threshold: " + this.varianceThreshold + "<br></html>");
        }
        JLabel headerLabel = new JLabel(result.toString());
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 18;
        c.insets = new Insets(11, 11, 11, 11);
        c.gridwidth = 0;
        layout.setConstraints(headerLabel, c);
        panel.add(headerLabel);
        JScrollPane tablePane = new JScrollPane(eigenvalueTable);
        c.weighty = 1.0;
        layout.setConstraints(tablePane, c);
        panel.add(tablePane);
        return panel;
    }

    private JComponent getVariancePlot() {
        SimpleDataTable dataTable = new SimpleDataTable("Cumulative Proportion of Variance", new String[]{"Principal Components", "Cumulative Proportion of Variance"});
        dataTable.add(new SimpleDataTableRow(new double[]{new Double(0.0), new Double(0.0)}));
        int i = 0;
        while (i < this.cumulativeVariance.length) {
            dataTable.add(new SimpleDataTableRow(new double[]{i + 1, this.cumulativeVariance[i]}));
            ++i;
        }
        ScatterPlotter plotter = new ScatterPlotter(dataTable);
        plotter.setAxis(0, 0);
        plotter.setPlotColumn(1, true);
        return plotter.getPlotter();
    }

    public Component getVisualizationComponent(IOContainer container) {
        this.visualizationPanel = new JPanel();
        this.visualizationPanel.setLayout(new BorderLayout());
        this.eigenValueTableButton = new JRadioButton("eigenvalues");
        this.eigenVectorTableButton = new JRadioButton("eigenvectors");
        this.cumulativeVariancePlotButton = new JRadioButton("variance plot");
        this.eigenValueTableButton.addActionListener(this);
        this.eigenVectorTableButton.addActionListener(this);
        this.cumulativeVariancePlotButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.eigenValueTableButton);
        group.add(this.eigenVectorTableButton);
        group.add(this.cumulativeVariancePlotButton);
        this.eigenValueTableButton.setSelected(true);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 3));
        buttons.add(this.eigenValueTableButton);
        buttons.add(this.eigenVectorTableButton);
        buttons.add(this.cumulativeVariancePlotButton);
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new BorderLayout());
        toppanel.add((Component)buttons, "West");
        this.visualizationPanel.add((Component)toppanel, "North");
        this.visualizationComponent = new Component[3];
        this.visualizationComponent[0] = this.getEigenvalueTable();
        this.visualizationComponent[1] = this.getEigenvectorTable();
        this.visualizationComponent[2] = this.getVariancePlot();
        this.visualizationPanel.add(this.visualizationComponent[0], "Center");
        this.lastSelectedIndex = 0;
        return this.visualizationPanel;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.visualizationPanel.remove(this.visualizationComponent[this.lastSelectedIndex]);
        if (this.eigenValueTableButton.isSelected()) {
            this.visualizationPanel.add(this.visualizationComponent[0], "Center");
            this.lastSelectedIndex = 0;
        } else if (this.eigenVectorTableButton.isSelected()) {
            this.visualizationPanel.add(this.visualizationComponent[1], "Center");
            this.lastSelectedIndex = 1;
        } else if (this.cumulativeVariancePlotButton.isSelected()) {
            this.visualizationPanel.add(this.visualizationComponent[2], "Center");
            this.lastSelectedIndex = 2;
        }
        this.visualizationPanel.repaint();
    }
}

