/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.selection.IterativeFeatureAdding;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightGuidedSelectionOperator
extends FeatureOperator {
    private int generationsWOImp;
    private int maxGenerations;
    private String[] attributeNames;

    public WeightGuidedSelectionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        this.generationsWOImp = this.getParameterAsInt("generations_without_improval");
        this.maxGenerations = es.getAttributes().size();
        Population initP = new Population();
        AttributeWeightedExampleSet exampleSet = new AttributeWeightedExampleSet((ExampleSet)es.clone());
        exampleSet.deselectAll();
        exampleSet.setWeight(exampleSet.getAttributes().getRegular(this.attributeNames[0]), 1.0);
        initP.add(new Individual(exampleSet));
        return initP;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        this.attributeNames = new String[input.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : input.getAttributes()) {
            this.attributeNames[index++] = attribute.getName();
        }
        AttributeWeights attributeWeights = this.getInput(AttributeWeights.class);
        attributeWeights.sortByWeight(this.attributeNames, 1, this.getParameterAsBoolean("use_absolute_weights") ? 1 : 0);
        preOp.add(new IterativeFeatureAdding(this.attributeNames, 1));
        return preOp;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after n generations without improval of the performance (-1: stops if the number of features is reached).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeBoolean("use_absolute_weights", "Indicates that the absolute values of the input weights should be used to determine the feature adding order.", true));
        return types;
    }
}

