/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionMutation
extends IndividualOperator {
    private double probability;
    private Random random;

    public SelectionMutation(double probability, Random random) {
        this.probability = probability;
        this.random = random;
    }

    @Override
    public List<Individual> operate(Individual individual) {
        LinkedList<Individual> l = new LinkedList<Individual>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)individual.getExampleSet().clone();
        double prob = this.probability < 0.0 ? 1.0 / (double)clone.getAttributes().size() : this.probability;
        for (Attribute attribute : clone.getAttributes()) {
            if (!(this.random.nextDouble() < prob)) continue;
            clone.flipAttributeUsed(attribute);
        }
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(new Individual(clone));
        }
        l.add(individual);
        return l;
    }
}

