/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

public class SelectionCrossover
implements PopulationOperator {
    public static final String[] CROSSOVER_TYPES = new String[]{"one_point", "uniform", "shuffle"};
    public static final int ONE_POINT = 0;
    public static final int UNIFORM = 1;
    public static final int SHUFFLE = 2;
    private int type;
    private double prob;
    private Random random;

    public SelectionCrossover(int type, double prob, Random random) {
        this.prob = prob;
        this.type = type;
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void crossover(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2) {
        switch (this.type) {
            case 0: {
                int n = 1 + this.random.nextInt(es1.getAttributes().size() - 1);
                int counter = 0;
                for (Attribute attribute : es1.getAttributes()) {
                    if (counter >= n) {
                        boolean dummy = es1.isAttributeUsed(attribute);
                        es1.setAttributeUsed(attribute, es2.isAttributeUsed(attribute));
                        es2.setAttributeUsed(attribute, dummy);
                    }
                    ++counter;
                }
                break;
            }
            case 1: {
                boolean[] swap = new boolean[es1.getAttributes().size()];
                int i = 0;
                while (i < swap.length) {
                    swap[i] = this.random.nextBoolean();
                    ++i;
                }
                this.swapAttributes(es1, es2, swap);
                break;
            }
            case 2: {
                boolean[] swap = new boolean[es1.getAttributes().size()];
                ArrayList<Integer> indices = new ArrayList<Integer>();
                int i = 0;
                while (i < swap.length) {
                    indices.add(i);
                    ++i;
                }
                if (indices.size() > 0) {
                    int toSwap = this.random.nextInt(indices.size() - 1) + 1;
                    int i2 = 0;
                    while (i2 < toSwap) {
                        swap[((Integer)indices.remove((int)this.random.nextInt((int)indices.size()))).intValue()] = true;
                        ++i2;
                    }
                }
                this.swapAttributes(es1, es2, swap);
                break;
            }
        }
    }

    private void swapAttributes(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2, boolean[] swap) {
        int index = 0;
        for (Attribute attribute : es1.getAttributes()) {
            if (!swap[index++]) continue;
            boolean dummy = es1.isAttributeUsed(attribute);
            es1.setAttributeUsed(attribute, es2.isAttributeUsed(attribute));
            es2.setAttributeUsed(attribute, dummy);
        }
    }

    public void operate(Population population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        LinkedList<AttributeWeightedExampleSet> matingPool = new LinkedList<AttributeWeightedExampleSet>();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            matingPool.add((AttributeWeightedExampleSet)population.get(i).getExampleSet().clone());
            ++i;
        }
        LinkedList<Individual> l = new LinkedList<Individual>();
        while (matingPool.size() > 1) {
            AttributeWeightedExampleSet p1 = (AttributeWeightedExampleSet)matingPool.remove(this.random.nextInt(matingPool.size()));
            AttributeWeightedExampleSet p2 = (AttributeWeightedExampleSet)matingPool.remove(this.random.nextInt(matingPool.size()));
            if (!(this.random.nextDouble() < this.prob)) continue;
            this.crossover(p1, p2);
            if (p1.getNumberOfUsedAttributes() > 0) {
                l.add(new Individual(p1));
            }
            if (p2.getNumberOfUsedAttributes() <= 0) continue;
            l.add(new Individual(p2));
        }
        population.addAllIndividuals(l);
    }
}

