/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class RouletteWheel
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;
    private Random random;

    public RouletteWheel(int popSize, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public double filterFitness(double fitness) {
        return fitness;
    }

    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        if (this.keepBest) {
            newGeneration.add(population.getBestIndividualEver());
        }
        double fitnessSum = 0.0;
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            fitnessSum += this.filterFitness(population.get(i).getPerformance().getMainCriterion().getFitness());
            ++i;
        }
        while (newGeneration.size() < this.popSize) {
            double r = fitnessSum * this.random.nextDouble();
            int j = 0;
            double f = 0.0;
            Individual individual = null;
            while ((f += this.filterFitness((individual = population.get(j++)).getPerformance().getMainCriterion().getFitness())) < r) {
            }
            newGeneration.add(individual);
        }
        population.clear();
        population.addAllIndividuals(newGeneration);
    }
}

