/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NominalAttributeStatistics;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUselessFeatures
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public RemoveUselessFeatures(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        ExampleSet clone = (ExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        double numericalMinDeviation = this.getParameterAsDouble("numerical_min_deviation");
        double nominalSingleValueUpper = this.getParameterAsDouble("nominal_single_value_upper");
        double nominalSingleValueLower = this.getParameterAsDouble("nominal_single_value_lower");
        if (nominalSingleValueLower < 0.0) {
            nominalSingleValueLower = 1.0 / (double)clone.size();
        }
        Iterator<Attribute> i = clone.getAttributes().iterator();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            if (attribute.isNominal()) {
                List<String> values = attribute.getMapping().getValues();
                double[] valueCounts = new double[values.size()];
                Iterator v = values.iterator();
                int n = 0;
                while (v.hasNext()) {
                    String value = (String)v.next();
                    valueCounts[n] = ((NominalAttributeStatistics)attribute.getStatistics()).getValueCount(value);
                    ++n;
                }
                double maximumValueCount = Double.NEGATIVE_INFINITY;
                n = 0;
                while (n < valueCounts.length) {
                    double percent = valueCounts[n] / (double)clone.size();
                    maximumValueCount = Math.max(maximumValueCount, percent);
                    if (percent >= nominalSingleValueUpper) {
                        i.remove();
                        break;
                    }
                    ++n;
                }
                if (maximumValueCount <= nominalSingleValueLower) {
                    i.remove();
                    break;
                }
            } else if (Math.sqrt(((NumericalAttributeStatistics)attribute.getStatistics()).getVariance()) <= numericalMinDeviation) {
                i.remove();
            }
            this.checkForStop();
        }
        if (clone.getAttributes().size() <= 0) {
            LogService.logMessage("Example set does not not have any attribute after removing the useless attributes!", 4);
        }
        return new IOObject[]{clone};
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("numerical_min_deviation", "Removes all numerical attributes with standard deviation less or equal to this threshold.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("nominal_single_value_upper", "Removes all nominal attributes which provides more than the given amount of only one value.", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("nominal_single_value_lower", "Removes all nominal attributes which provides less than the given amount of at least one value (-1: remove attributes with values occuring only once).", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

