/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveCorrelatedFeatures
extends Operator {
    private static final String[] ORDER = new String[]{"original", "random", "reverse"};
    private static final int ORDER_ORIGINAL = 0;
    private static final int ORDER_RANDOM = 1;
    private static final int ORDER_REVERSE = 2;
    private static final String[] FILTER_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private int removedFeatures = 0;

    public RemoveCorrelatedFeatures(OperatorDescription description) {
        super(description);
        this.addValue(new Value("features_removed", "Number of removed features"){

            public double getValue() {
                return RemoveCorrelatedFeatures.this.removedFeatures;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[exampleSet.getAttributes().size()];
        double[] deviations = new double[exampleSet.getAttributes().size()];
        boolean[] removeFeature = new boolean[exampleSet.getAttributes().size()];
        int[] attributeIndex = new int[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            NumericalAttributeStatistics stats = (NumericalAttributeStatistics)attribute.getStatistics();
            means[index] = stats.getAverage();
            deviations[index] = Math.sqrt(stats.getVariance());
            removeFeature[index] = false;
            attributeIndex[index] = index;
            ++index;
        }
        double[][] samples = new double[exampleSet.size()][exampleSet.getAttributes().size()];
        int counter = 0;
        for (Example example : exampleSet) {
            int d = 0;
            for (Attribute attribute : example.getAttributes()) {
                samples[counter][d++] = example.getValue(attribute);
            }
            ++counter;
        }
        int order = this.getParameterAsInt("attribute_order");
        if (order == 0) {
            int i = 0;
            while (i < exampleSet.getAttributes().size()) {
                attributeIndex[i] = i;
                ++i;
            }
        } else if (order == 1) {
            Vector<Integer> vector = new Vector<Integer>();
            int i = 0;
            while (i < exampleSet.getAttributes().size()) {
                vector.add(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < exampleSet.getAttributes().size()) {
                int vindex = (int)Math.floor(Math.random() * (double)vector.size());
                attributeIndex[i2] = (Integer)vector.remove(vindex);
                ++i2;
            }
        } else if (order == 2) {
            int i = 0;
            while (i < exampleSet.getAttributes().size()) {
                attributeIndex[i] = exampleSet.getAttributes().size() - 1 - i;
                ++i;
            }
        }
        boolean absolute = this.getParameterAsBoolean("use_absolute_correlation");
        int relation = this.getParameterAsInt("filter_relation");
        double threshold = this.getParameterAsDouble("correlation");
        if (absolute && threshold < 0.0) {
            threshold = Math.abs(threshold);
            LogService.logMessage("Correlation value is lower zero. Setting to absolute: " + threshold, 4);
        }
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        int i = 0;
        while (i < exampleSet.getAttributes().size() - 1) {
            if (!removeFeature[attributeIndex[i]]) {
                int j = i + 1;
                while (j < exampleSet.getAttributes().size()) {
                    if (!removeFeature[attributeIndex[j]]) {
                        double correlation = this.getCorrelation(samples, means, deviations, attributeIndex[i], attributeIndex[j]);
                        if (absolute) {
                            correlation = Math.abs(correlation);
                        }
                        if (this.fulfillRelation(correlation, threshold, relation)) {
                            removeFeature[attributeIndex[j]] = true;
                            String first = allAttributes[attributeIndex[i]].getName();
                            String second = allAttributes[attributeIndex[j]].getName();
                            LogService.logMessage("Removed Attribute : " + second + " --> correlation(" + first + "," + second + ")=" + correlation, 2);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.removedFeatures = 0;
        index = 0;
        Iterator<Attribute> iterator = exampleSet.getAttributes().iterator();
        while (iterator.hasNext()) {
            if (!removeFeature[index++]) continue;
            iterator.remove();
            ++this.removedFeatures;
        }
        LogService.logMessage("Removed " + this.removedFeatures + "Features." + Tools.getLineSeparator() + "ExampleSet has now " + exampleSet.getAttributes().size() + " Features.", 2);
        return new IOObject[]{exampleSet};
    }

    private boolean fulfillRelation(double correlation, double threshold, int relation) {
        switch (relation) {
            case 0: {
                return correlation > threshold;
            }
            case 1: {
                return correlation >= threshold;
            }
            case 2: {
                return correlation == threshold;
            }
            case 3: {
                return correlation <= threshold;
            }
            case 4: {
                return correlation < threshold;
            }
        }
        return false;
    }

    private double getCorrelation(double[][] samples, double[] means, double[] deviations, int att1, int att2) {
        double covariance = 0.0;
        int j = 0;
        while (j < samples.length) {
            covariance += (samples[j][att1] - means[att1]) * (samples[j][att2] - means[att2]);
            ++j;
        }
        double correlation = 0.0;
        correlation = deviations[att1] * deviations[att2];
        correlation = correlation == 0.0 ? covariance : (covariance /= (double)(samples.length - 1)) / correlation;
        return correlation;
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble("correlation", "Use this correlation for the filter relation.", -1.0, 1.0, 0.95);
        list.add(type);
        type = new ParameterTypeCategory("filter_relation", "Removes one of two features if their correlation fulfill this relation.", FILTER_RELATIONS, 0);
        list.add(type);
        type = new ParameterTypeCategory("attribute_order", "The algorithm takes this attribute order to calculate correlation and filter.", ORDER, 0);
        list.add(type);
        type = new ParameterTypeBoolean("use_absolute_correlation", "Indicates if the absolute value of the correlations should be used for comparison.", true);
        list.add(type);
        return list;
    }
}

