/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class RankSelection
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;
    private Random random;

    public RankSelection(int popSize, boolean keepBest, Random random) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.random = random;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void operate(Population population) {
        LinkedList<Individual> newGeneration = new LinkedList<Individual>();
        if (this.keepBest) {
            newGeneration.add(population.getBestIndividualEver());
        }
        population.sort();
        double fitnessSum = (double)(population.getNumberOfIndividuals() * (population.getNumberOfIndividuals() + 1)) / 2.0;
        while (newGeneration.size() < this.popSize) {
            double r = fitnessSum * this.random.nextDouble();
            int j = -1;
            double f = 0.0;
            while ((f += (double)(++j)) < r) {
            }
            newGeneration.add(population.get(j));
        }
        population.clear();
        population.addAllIndividuals(newGeneration);
    }
}

