/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.selection.AbstractGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.selection.SelectionCrossover;
import edu.udo.cs.yale.operator.features.selection.SelectionMutation;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneticAlgorithm
extends AbstractGeneticAlgorithm {
    public GeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        Population initP = new Population();
        while (initP.getNumberOfIndividuals() < this.getParameterAsInt("population_size")) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            for (Attribute attribute : nes.getAttributes()) {
                if (!(this.getRandom().nextDouble() < 1.0 - this.getParameterAsDouble("p_initialize"))) continue;
                nes.flipAttributeUsed(attribute);
            }
            if (nes.getNumberOfUsedAttributes() <= 0) continue;
            initP.add(new Individual(nes));
        }
        return initP;
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pMutation = this.getParameterAsDouble("p_mutation");
        return new SelectionMutation(pMutation, this.getRandom());
    }

    @Override
    protected PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pCrossover = this.getParameterAsDouble("p_crossover");
        int crossoverType = this.getParameterAsInt("crossover_type");
        return new SelectionCrossover(crossoverType, pCrossover, this.getRandom());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("p_initialize", "Initial probability for an attribute to be switched on.", 0.0, 1.0, 0.5));
        ParameterTypeDouble type = new ParameterTypeDouble("p_mutation", "Probability for an attribute to be changed (-1: 1 / numberOfAtt).", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p_crossover", "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("crossover_type", "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        return types;
    }
}

