/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.KeepBest;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RedundanceRemoval;
import edu.udo.cs.yale.operator.features.selection.BackwardElimination;
import edu.udo.cs.yale.operator.features.selection.ForwardSelection;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSelectionOperator
extends FeatureOperator {
    public static final int FORWARD_SELECTION = 0;
    public static final int BACKWARD_ELIMINATION = 1;
    private static final String[] DIRECTIONS = new String[]{"forward", "backward"};
    private int generationsWOImp;
    private int maxGenerations;

    public FeatureSelectionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.maxGenerations = this.getParameterAsInt("maximum_number_of_generations");
        this.generationsWOImp = this.getParameterAsInt("generations_without_improval");
        return super.apply();
    }

    int getDefaultDirection() {
        return 0;
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        int direction = this.getParameterAsInt("selection_direction");
        Population initP = new Population();
        if (direction == 0) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            nes.getAttributes().clearRegular();
            for (Attribute attribute : es.getAttributes()) {
                AttributeWeightedExampleSet forwardES = (AttributeWeightedExampleSet)nes.clone();
                forwardES.getAttributes().addRegular(attribute);
                if (forwardES.getNumberOfUsedAttributes() <= 0) continue;
                initP.add(new Individual(forwardES));
            }
        } else {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            for (Attribute attribute : nes.getAttributes()) {
                nes.setAttributeUsed(attribute, true);
            }
            if (nes.getNumberOfUsedAttributes() > 0) {
                initP.add(new Individual(nes));
            }
        }
        return initP;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        int direction = this.getParameterAsInt("selection_direction");
        int keepBest = this.getParameterAsInt("keep_best");
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        preOp.add(new KeepBest(keepBest));
        if (direction == 0) {
            preOp.add(new ForwardSelection(input));
            this.maxGenerations = this.maxGenerations <= 0 ? input.getAttributes().size() - 1 : --this.maxGenerations;
        } else {
            preOp.add(new BackwardElimination());
            if (this.maxGenerations <= 0) {
                this.maxGenerations = input.getAttributes().size();
            }
        }
        preOp.add(new RedundanceRemoval());
        return preOp;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory type = new ParameterTypeCategory("selection_direction", "Forward selection or backward elimination.", DIRECTIONS, this.getDefaultDirection());
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("keep_best", "Keep the best n individuals in each generation.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt("generations_without_improval", "Stop after n generations without improval of the performance (-1: stops if the maximum_number_of_generations is reached).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt("maximum_number_of_generations", "Delivers the maximum amount of generations (-1: might use or deselect all features).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

