/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BruteForceSelection
extends FeatureOperator {
    public BruteForceSelection(OperatorDescription description) {
        super(description);
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) {
        AttributeWeightedExampleSet exampleSet = new AttributeWeightedExampleSet(es);
        for (Attribute attribute : exampleSet.getAttributes()) {
            exampleSet.setAttributeUsed(attribute, false);
        }
        Population pop = new Population();
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        this.addAll(pop, exampleSet, allAttributes, 0);
        return pop;
    }

    private void addAll(Population pop, AttributeWeightedExampleSet es, Attribute[] allAttributes, int startIndex) {
        if (startIndex >= allAttributes.length) {
            return;
        }
        Attribute attribute = allAttributes[startIndex];
        AttributeWeightedExampleSet ce2 = (AttributeWeightedExampleSet)es.clone();
        ce2.setAttributeUsed(attribute, false);
        this.addAll(pop, ce2, allAttributes, startIndex + 1);
        AttributeWeightedExampleSet ce1 = (AttributeWeightedExampleSet)es.clone();
        ce1.setAttributeUsed(attribute, true);
        if (ce1.getNumberOfUsedAttributes() > 0) {
            pop.add(new Individual(ce1));
        }
        this.addAll(pop, ce1, allAttributes, startIndex + 1);
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) {
        return true;
    }
}

