/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.selection.RouletteWheel;
import java.util.Random;

public class BoltzmannSelection
extends RouletteWheel {
    private double temperature;
    private double delta = 0.0;

    public BoltzmannSelection(int popSize, double temperature, int maxGenerations, boolean dynamic, boolean keepBest, Random random) {
        super(popSize, keepBest, random);
        this.temperature = temperature;
        if (dynamic) {
            this.delta = this.temperature / (double)(maxGenerations + 1);
        }
    }

    public double filterFitness(double fitness) {
        return Math.exp(fitness / this.temperature);
    }

    public void operate(Population population) {
        super.operate(population);
        this.temperature -= this.delta;
    }
}

