/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeightSelection
extends Operator {
    private static final String[] WEIGHT_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less", "top k", "bottom k", "all but top k", "all but bottom k", "top p%", "bottom p%"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private static final int TOPK = 5;
    private static final int BOTTOMK = 6;
    private static final int ALLBUTTOPK = 7;
    private static final int ALLBUTBOTTOMK = 8;
    private static final int TOPPPERCENT = 9;
    private static final int BOTTOMPPERCENT = 10;

    public AttributeWeightSelection(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        AttributeWeights weights = this.getInput(AttributeWeights.class);
        boolean deselectUnknown = this.getParameterAsBoolean("deselect_unknown");
        double relationWeight = this.getParameterAsDouble("weight");
        int relation = this.getParameterAsInt("weight_relation");
        boolean useAbsoluteWeights = this.getParameterAsBoolean("use_absolute_weights");
        int nrAtts = eSet.getAttributes().size();
        int k = this.getParameterAsInt("k");
        if (relation == 7) {
            relation = 6;
            k = nrAtts - k;
        }
        if (relation == 8) {
            relation = 5;
            k = nrAtts - k;
        }
        if (relation == 9) {
            relation = 5;
            k = (int)Math.floor((double)nrAtts * this.getParameterAsDouble("p"));
        }
        if (relation == 10) {
            relation = 6;
            k = (int)Math.floor((double)nrAtts * this.getParameterAsDouble("p"));
        }
        if (k < 1) {
            k = 1;
        }
        if (k > nrAtts) {
            k = nrAtts;
        }
        if (relation == 5 || relation == 6) {
            double threshold;
            double[] allWeights = new double[eSet.getAttributes().size()];
            double unknownSortValue = relation == 5 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            Iterator<Attribute> iterator = eSet.getAttributes().iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                double weight = weights.getWeight(attribute.getName());
                if (useAbsoluteWeights) {
                    weight = Math.abs(weight);
                }
                if (Double.isNaN(weight) && deselectUnknown) {
                    iterator.remove();
                }
                allWeights[index++] = weight;
            }
            Arrays.sort(allWeights);
            if (relation == 5) {
                threshold = allWeights[allWeights.length - k];
                while (k > 1 && threshold == unknownSortValue) {
                    threshold = allWeights[allWeights.length - --k];
                }
            } else {
                threshold = allWeights[k - 1];
                while (k > 1 && threshold == unknownSortValue) {
                    threshold = allWeights[--k - 1];
                }
            }
            iterator = eSet.getAttributes().iterator();
            index = 0;
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                double weight = weights.getWeight(attribute.getName());
                if (useAbsoluteWeights) {
                    weight = Math.abs(weight);
                }
                if (Double.isNaN(weight) && deselectUnknown) {
                    iterator.remove();
                    continue;
                }
                if (relation == 5) {
                    if (!(weight < threshold)) continue;
                    iterator.remove();
                    continue;
                }
                if (!(weight > threshold)) continue;
                iterator.remove();
            }
        } else {
            Iterator<Attribute> iterator = eSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                double weight = weights.getWeight(attribute.getName());
                if (useAbsoluteWeights) {
                    weight = Math.abs(weight);
                }
                if (Double.isNaN(weight) && deselectUnknown) {
                    iterator.remove();
                    continue;
                }
                switch (relation) {
                    case 0: {
                        if (!(weight <= relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 1: {
                        if (!(weight < relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 2: {
                        if (weight == relationWeight) break;
                        iterator.remove();
                        break;
                    }
                    case 3: {
                        if (!(weight > relationWeight)) break;
                        iterator.remove();
                        break;
                    }
                    case 4: {
                        if (!(weight >= relationWeight)) break;
                        iterator.remove();
                    }
                }
            }
        }
        return new IOObject[]{eSet};
    }

    @Override
    public InputDescription getInputDescription(Class cls) {
        if (AttributeWeights.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class, AttributeWeights.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble("weight", "Use this weight for the selection relation.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("weight_relation", "Selects only weights which fulfill this relation.", WEIGHT_RELATIONS, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("k", "Number k of attributes to be selected for weight-relations 'top k' or 'bottom k'.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p", "Percentage of attributes to be selected for weight-relations 'top p%' or 'bottom p%'.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("deselect_unknown", "Indicates if attributes which weight is unknown should be deselected.", true));
        types.add(new ParameterTypeBoolean("use_absolute_weights", "Indicates if the absolute values of the weights should be used for comparison.", true));
        return types;
    }
}

