/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.selection;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.selection.BoltzmannSelection;
import edu.udo.cs.yale.operator.features.selection.CutSelection;
import edu.udo.cs.yale.operator.features.selection.NonDominatedSortingSelection;
import edu.udo.cs.yale.operator.features.selection.RankSelection;
import edu.udo.cs.yale.operator.features.selection.RouletteWheel;
import edu.udo.cs.yale.operator.features.selection.StochasticUniversalSampling;
import edu.udo.cs.yale.operator.features.selection.TournamentSelection;
import edu.udo.cs.yale.operator.features.selection.UniformSelection;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneticAlgorithm
extends FeatureOperator {
    public static final String[] SELECTION_SCHEMES = new String[]{"uniform", "cut", "roulette wheel", "stochastic universal sampling", "Boltzmann", "rank", "tournament", "non dominated sorting"};
    public static final int UNIFORM_SELECTION = 0;
    public static final int CUT_SELECTION = 1;
    public static final int ROULETTE_WHEEL = 2;
    public static final int STOCHASTIC_UNIVERSAL = 3;
    public static final int BOLTZMANN_SELECTION = 4;
    public static final int RANK_SELECTION = 5;
    public static final int TOURNAMENT_SELECTION = 6;
    public static final int NON_DOMINATED_SORTING_SELECTION = 7;
    private int numberOfIndividuals;
    private int maxGen;
    private int generationsWithoutImproval;

    public AbstractGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    protected abstract PopulationOperator getMutationPopulationOperator(ExampleSet var1) throws OperatorException;

    protected abstract PopulationOperator getCrossoverPopulationOperator(ExampleSet var1) throws OperatorException;

    protected List<PopulationOperator> getPreProcessingPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    protected List<PopulationOperator> getPostProcessingPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public final List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        PopulationOperator mutation;
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        PopulationOperator crossover = this.getCrossoverPopulationOperator(input);
        if (crossover != null) {
            preOp.add(crossover);
        }
        if ((mutation = this.getMutationPopulationOperator(input)) != null) {
            preOp.add(mutation);
        }
        preOp.addAll(this.getPreProcessingPopulationOperators(input));
        return preOp;
    }

    @Override
    public final List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> postOp = new LinkedList<PopulationOperator>();
        this.numberOfIndividuals = this.getParameterAsInt("population_size");
        this.maxGen = this.getParameterAsInt("maximum_number_of_generations");
        this.generationsWithoutImproval = this.getParameterAsInt("generations_without_improval");
        if (this.generationsWithoutImproval < 1) {
            this.generationsWithoutImproval = this.maxGen;
        }
        boolean keepBest = this.getParameterAsBoolean("keep_best_individual");
        boolean dynamicSelection = this.getParameterAsBoolean("dynamic_selection_pressure");
        int selectionScheme = this.getParameterAsInt("selection_scheme");
        switch (selectionScheme) {
            case 0: {
                postOp.add(new UniformSelection(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 1: {
                postOp.add(new CutSelection(this.numberOfIndividuals));
                break;
            }
            case 2: {
                postOp.add(new RouletteWheel(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 3: {
                postOp.add(new StochasticUniversalSampling(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 4: {
                postOp.add(new BoltzmannSelection(this.numberOfIndividuals, this.getParameterAsDouble("start_temperature"), this.maxGen, dynamicSelection, keepBest, this.getRandom()));
                break;
            }
            case 5: {
                postOp.add(new RankSelection(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 6: {
                postOp.add(new TournamentSelection(this.numberOfIndividuals, this.getParameterAsDouble("tournament_size"), this.maxGen, dynamicSelection, keepBest, this.getRandom()));
                break;
            }
            case 7: {
                postOp.add(new NonDominatedSortingSelection(this.numberOfIndividuals));
                this.setCheckForMaximum(false);
                break;
            }
        }
        postOp.addAll(this.getPostProcessingPopulationOperators(input));
        return postOp;
    }

    @Override
    public boolean solutionGoodEnough(Population pop) {
        return pop.getGeneration() >= this.maxGen || pop.getGenerationsWithoutImproval() >= this.generationsWithoutImproval;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("population_size", "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("maximum_number_of_generations", "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("generations_without_improval", "Stop criterion: Stop after n generations without improval of the performance (-1: perform all generations).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("selection_scheme", "The selection scheme of this EA.", SELECTION_SCHEMES, 6));
        types.add(new ParameterTypeDouble("tournament_size", "The fraction of the current population which should be used as tournament members (only tournament selection).", 0.0, 1.0, 0.25));
        types.add(new ParameterTypeDouble("start_temperature", "The scaling temperature (only Boltzmann selection).", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("dynamic_selection_pressure", "If set to true the selection pressure is increased to maximum during the complete optimization run (only Boltzmann and tournament selection).", true));
        types.add(new ParameterTypeBoolean("keep_best_individual", "If set to true, the best individual of each generations is guaranteed to be selected for the next generation (elitist selection).", false));
        return types;
    }
}

