/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.AbsoluteValueGenerator;
import edu.udo.cs.yale.generator.ExponentialFunctionGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.FloorCeilGenerator;
import edu.udo.cs.yale.generator.MinMaxGenerator;
import edu.udo.cs.yale.generator.PowerGenerator;
import edu.udo.cs.yale.generator.SquareRootGenerator;
import edu.udo.cs.yale.generator.TrigonometricFunctionGenerator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.EquivalentAttributeRemoval;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RemoveUselessAttributes;
import edu.udo.cs.yale.operator.features.construction.ConstantGeneration;
import edu.udo.cs.yale.operator.features.construction.GeneratingMutation;
import edu.udo.cs.yale.operator.features.construction.YAGGA;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YAGGA2
extends YAGGA {
    public YAGGA2(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        if (this.getParameterAsBoolean("restrictive_selection")) {
            FeatureGenerator.setSelectionMode(1);
        } else {
            FeatureGenerator.setSelectionMode(0);
        }
        return super.apply();
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet exampleSet) throws OperatorException {
        GeneratingMutation mutation = (GeneratingMutation)super.getMutationPopulationOperator(exampleSet);
        mutation.setMaxConstructionDepth(this.getParameterAsInt("max_construction_depth"));
        String unused = this.getParameterAsString("unused_functions");
        if (unused != null) {
            mutation.setUnusedFunctions(unused.split(" "));
        }
        return mutation;
    }

    @Override
    public List<FeatureGenerator> getGenerators() {
        List<FeatureGenerator> generators = super.getGenerators();
        if (this.getParameterAsBoolean("use_square_roots")) {
            generators.add(new SquareRootGenerator());
        }
        if (this.getParameterAsBoolean("use_power_functions")) {
            generators.add(new PowerGenerator());
        }
        if (this.getParameterAsBoolean("use_sin")) {
            generators.add(new TrigonometricFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean("use_cos")) {
            generators.add(new TrigonometricFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean("use_tan")) {
            generators.add(new TrigonometricFunctionGenerator(2));
        }
        if (this.getParameterAsBoolean("use_atan")) {
            generators.add(new TrigonometricFunctionGenerator(3));
        }
        if (this.getParameterAsBoolean("use_exp")) {
            generators.add(new ExponentialFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean("use_log")) {
            generators.add(new ExponentialFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean("use_absolute_values")) {
            generators.add(new AbsoluteValueGenerator());
        }
        if (this.getParameterAsBoolean("use_min")) {
            generators.add(new MinMaxGenerator(0));
        }
        if (this.getParameterAsBoolean("use_max")) {
            generators.add(new MinMaxGenerator(1));
        }
        if (this.getParameterAsBoolean("use_floor_ceil_functions")) {
            generators.add(new FloorCeilGenerator(0));
            generators.add(new FloorCeilGenerator(1));
            generators.add(new FloorCeilGenerator(2));
        }
        return generators;
    }

    @Override
    protected List<PopulationOperator> getPreProcessingPopulationOperators(ExampleSet eSet) throws OperatorException {
        List<PopulationOperator> popOps = super.getPreProcessingPopulationOperators(eSet);
        double constantProb = this.getParameterAsDouble("constant_generation_prob");
        if (constantProb > 0.0) {
            popOps.add(new ConstantGeneration(constantProb, this.getRandom()));
        }
        if (this.getParameterAsBoolean("remove_useless")) {
            popOps.add(new RemoveUselessAttributes());
        }
        if (this.getParameterAsBoolean("remove_equivalent")) {
            popOps.add(new EquivalentAttributeRemoval(this.getParameterAsInt("equivalence_samples"), this.getParameterAsDouble("equivalence_epsilon"), this.getParameterAsBoolean("equivalence_use_statistics"), this.getRandom()));
        }
        return popOps;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("use_square_roots", "Generate square root values.", false));
        types.add(new ParameterTypeBoolean("use_power_functions", "Generate the power of one attribute and another.", true));
        types.add(new ParameterTypeBoolean("use_sin", "Generate sinus.", true));
        types.add(new ParameterTypeBoolean("use_cos", "Generate cosinus.", false));
        types.add(new ParameterTypeBoolean("use_tan", "Generate tangens.", false));
        types.add(new ParameterTypeBoolean("use_atan", "Generate arc tangens.", false));
        types.add(new ParameterTypeBoolean("use_exp", "Generate exponential functions.", true));
        types.add(new ParameterTypeBoolean("use_log", "Generate logarithmic functions.", false));
        types.add(new ParameterTypeBoolean("use_absolute_values", "Generate absolute values.", true));
        types.add(new ParameterTypeBoolean("use_min", "Generate minimum values.", false));
        types.add(new ParameterTypeBoolean("use_max", "Generate maximum values.", false));
        types.add(new ParameterTypeBoolean("use_floor_ceil_functions", "Generate floor, ceil, and rounded values.", false));
        types.add(new ParameterTypeBoolean("restrictive_selection", "Use restrictive generator selection (faster).", true));
        types.add(new ParameterTypeBoolean("remove_useless", "Remove useless attributes.", true));
        types.add(new ParameterTypeBoolean("remove_equivalent", "Remove equivalent attributes.", true));
        types.add(new ParameterTypeInt("equivalence_samples", "Check this number of samples to prove equivalency.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble("equivalence_epsilon", "Consider two attributes equivalent if their difference is not bigger than epsilon.", 0.0, Double.POSITIVE_INFINITY, 0.05));
        types.add(new ParameterTypeBoolean("equivalence_use_statistics", "Recalculates attribute statistics before equivalence check.", true));
        types.add(new ParameterTypeInt("max_construction_depth", "The maximum depth for the argument attributes used for attribute construction (-1: allow all depths).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeString("unused_functions", "Space separated list of functions which are not allowed in arguments for attribute construction."));
        types.add(new ParameterTypeDouble("constant_generation_prob", "Generate random constant attributes with this probability.", 0.0, 1.0, 0.02));
        types.add(new ParameterTypeBoolean("associative_attribute_merging", "Post processing after crossover (only possible for runs with only one generator).", false));
        return types;
    }
}

