/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.construction.AbstractGeneratingGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.construction.GeneratingMutation;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YAGGA
extends AbstractGeneratingGeneticAlgorithm {
    public YAGGA(OperatorDescription description) {
        super(description);
    }

    @Override
    protected PopulationOperator getGeneratingPopulationOperator(ExampleSet exampleSet) {
        return null;
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (Attribute attribute : eSet.getAttributes()) {
            attributes.add(attribute);
        }
        double pMutation = this.getParameterAsDouble("p_mutation");
        int maxNumberOfAttributes = this.getParameterAsInt("max_total_number_of_attributes");
        return new GeneratingMutation(attributes, pMutation, maxNumberOfAttributes, generators, this.getRandom());
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        Population population = super.createInitialPopulation(es);
        Population popRemovedDeselected = new Population();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            popRemovedDeselected.add(new Individual(population.get(i).getExampleSet().createCleanClone()));
            ++i;
        }
        return popRemovedDeselected;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeDouble("p_mutation", "Probability for mutation (-1: 1/n).", 0.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("max_total_number_of_attributes", "Max total number of attributes in all generations (-1: no maximum).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

