/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearCombinationOperator
extends Operator {
    public LinearCombinationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNominal()) continue;
            throw new UserError((Operator)this, 104, new Object[]{"Linear Combination", attribute.getName()});
        }
        Attribute newAttribute = AttributeFactory.createAttribute("linear_combination", 4);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            double valueSum = 0.0;
            for (Attribute attribute : example.getAttributes()) {
                if (attribute.equals(newAttribute)) continue;
                valueSum += example.getValue(attribute);
            }
            example.setValue(newAttribute, valueSum);
        }
        if (!this.getParameterAsBoolean("keep_all")) {
            exampleSet.getAttributes().clearRegular();
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("keep_all", "Indicates if the all old attributes should be kept.", false));
        return types;
    }
}

