/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratingMutation
extends IndividualOperator {
    private List<FeatureGenerator> generators;
    private List<Attribute> originalAttributes;
    private double prob;
    private int maxNumberOfAttributes;
    private RandomGenerator random;
    private int maxDepth = -1;
    private String[] unusedFunctions = new String[0];

    public GeneratingMutation(List<Attribute> originalAttributes, double prob, int maxNumberOfAttributes, List<FeatureGenerator> generators, RandomGenerator random) {
        this.originalAttributes = originalAttributes;
        this.prob = prob;
        this.maxNumberOfAttributes = maxNumberOfAttributes;
        this.generators = generators;
        this.random = random;
    }

    public void setMaxConstructionDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setUnusedFunctions(String[] functions) {
        this.unusedFunctions = functions;
    }

    @Override
    public List<Individual> operate(Individual individual) throws Exception {
        LinkedList<Individual> l = new LinkedList<Individual>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)individual.getExampleSet().clone();
        double p = this.prob < 0.0 ? 1.0 / (double)clone.getAttributes().size() : this.prob;
        p /= 4.0;
        try {
            if (this.maxNumberOfAttributes < 0 || clone.getAttributes().size() < this.maxNumberOfAttributes) {
                this.addOriginalAttribute(clone, p);
            }
            boolean generationPossible = false;
            if (this.maxNumberOfAttributes < 0 || clone.getAttributes().size() <= this.maxNumberOfAttributes) {
                generationPossible = this.addGeneratedAttribute(clone, p);
            }
            this.deselect(clone, generationPossible ? 2 : 1, p);
        }
        catch (GenerationException e) {
            LogService.logMessage("GeneratingMutation: Exception occured during generation of attributes, using only original example set instead.", 4);
        }
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(new Individual(clone));
        }
        l.add(individual);
        return l;
    }

    private boolean addGeneratedAttribute(AttributeWeightedExampleSet exampleSet, double p) throws Exception {
        if (this.random.nextDouble() < p) {
            FeatureGenerator generator = FeatureGenerator.selectGenerator(exampleSet, this.generators, this.maxDepth, this.unusedFunctions, this.random);
            if (generator != null) {
                generator = generator.newInstance();
                Attribute[] args = Tools.getRandomCompatibleAttributes(exampleSet, generator, this.maxDepth, this.unusedFunctions, this.random);
                generator.setArguments(args);
                LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
                generatorList.add(generator);
                List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
                for (Attribute newAttribute : newAttributes) {
                    exampleSet.getAttributes().addRegular(newAttribute);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addOriginalAttribute(AttributeWeightedExampleSet exampleSet, double p) {
        if (this.random.nextDouble() < p) {
            int i = this.random.nextInt(this.originalAttributes.size());
            Attribute originalAttribute = this.originalAttributes.get(i);
            if (exampleSet.getAttributes().get(originalAttribute.getName()) == null) {
                exampleSet.getAttributes().addRegular(originalAttribute);
            }
        }
    }

    private void deselect(AttributeWeightedExampleSet exampleSet, int m, double p) {
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        while (i.hasNext()) {
            i.next();
            if (!(this.random.nextDouble() < (double)m * p / (double)this.originalAttributes.size())) continue;
            i.remove();
        }
    }
}

