/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.construction.AbstractGeneratingGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.construction.AttributeGenerator;
import edu.udo.cs.yale.operator.features.selection.SelectionMutation;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratingGeneticAlgorithm
extends AbstractGeneratingGeneticAlgorithm {
    public GeneratingGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pMutation = this.getParameterAsDouble("p_mutation");
        return new SelectionMutation(pMutation, this.getRandom());
    }

    @Override
    protected PopulationOperator getGeneratingPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        int noOfNewAttributes = this.getParameterAsInt("max_number_of_new_attributes");
        int totalNoOfNewAttributes = this.getParameterAsInt("max_total_number_of_attributes");
        double pGenerate = this.getParameterAsDouble("p_generate");
        return new AttributeGenerator(pGenerate, noOfNewAttributes, totalNoOfNewAttributes, generators, this.getRandom());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("max_number_of_new_attributes", "Max number of attributes to generate for an individual in one generation.", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("max_total_number_of_attributes", "Max total number of attributes in all generations (-1: no maximum).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p_generate", "Probability for an individual to be selected for generation.", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p_mutation", "Probability for an attribute to be changed (-1: 1 / numberOfAtts).", -1.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

