/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.MinMaxGenerator;
import edu.udo.cs.yale.generator.ReciprocalValueGenerator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.KeepBest;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RedundanceRemoval;
import edu.udo.cs.yale.operator.features.selection.FeatureSelectionOperator;
import edu.udo.cs.yale.operator.features.selection.SwitchingForwardSelection;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratingForwardSelection
extends FeatureSelectionOperator {
    private Attribute[] originalAttributes;
    private Individual bestIndividual;
    private List<FeatureGenerator> useGenerators;
    private int newAttributeStart;
    private int turn;

    public GeneratingForwardSelection(OperatorDescription description) {
        super(description);
        this.addValue(new Value("turn", "The number of the current turn."){

            public double getValue() {
                return GeneratingForwardSelection.this.turn;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        FeatureGenerator g;
        this.newAttributeStart = 0;
        this.turn = 0;
        this.bestIndividual = null;
        this.originalAttributes = null;
        this.useGenerators = new LinkedList<FeatureGenerator>();
        if (this.getParameterAsBoolean("reciprocal_value")) {
            g = new ReciprocalValueGenerator();
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_plus")) {
            g = new BasicArithmeticOperationGenerator(0);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_diff")) {
            g = new BasicArithmeticOperationGenerator(1);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_mult")) {
            g = new BasicArithmeticOperationGenerator(2);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_div")) {
            g = new BasicArithmeticOperationGenerator(3);
            this.useGenerators.add(g);
        }
        if (this.getParameterAsBoolean("use_max")) {
            g = new MinMaxGenerator(1);
            this.useGenerators.add(g);
        }
        if (this.useGenerators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        if (this.getParameterAsBoolean("restrictive_selection")) {
            FeatureGenerator.setSelectionMode(1);
        } else {
            FeatureGenerator.setSelectionMode(0);
        }
        return super.apply();
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) {
        this.originalAttributes = es.getAttributes().createRegularAttributeArray();
        Population initP = new Population();
        AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
        for (Attribute attribute : es.getAttributes()) {
            nes.setAttributeUsed(attribute, false);
        }
        for (Attribute attribute : es.getAttributes()) {
            AttributeWeightedExampleSet forwardES = (AttributeWeightedExampleSet)nes.clone();
            forwardES.setAttributeUsed(attribute, true);
            initP.add(new Individual(forwardES));
        }
        return initP;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        preOp.add(new KeepBest(this.getParameterAsInt("keep_best")));
        preOp.add(new SwitchingForwardSelection());
        preOp.add(new RedundanceRemoval());
        return preOp;
    }

    @Override
    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        if (super.solutionGoodEnough(pop)) {
            if (pop.getNumberOfIndividuals() <= 0) {
                return true;
            }
            Individual fsBest = pop.getBestIndividualEver();
            AttributeWeightedExampleSet fsBestExampleSet = (AttributeWeightedExampleSet)fsBest.getExampleSet().clone();
            if (this.bestIndividual == null || this.bestIndividual.getPerformance() == null || fsBest.getPerformance().compareTo(this.bestIndividual.getPerformance()) > 0) {
                ++this.turn;
                this.bestIndividual = new Individual((AttributeWeightedExampleSet)fsBestExampleSet.clone());
                fsBestExampleSet = new AttributeWeightedExampleSet(fsBestExampleSet.createCleanClone());
                Attribute[] fsBestAttributes = fsBestExampleSet.getAttributes().createRegularAttributeArray();
                LogService.logMessage(String.valueOf(this.getName()) + ": " + Tools.ordinalNumber(this.turn) + " turn's FS result: " + fsBest, 2);
                LinkedList<FeatureGenerator> generators = new LinkedList<FeatureGenerator>();
                Iterator i = this.useGenerators.listIterator();
                while (i.hasNext()) {
                    int a;
                    FeatureGenerator fg = (FeatureGenerator)i.next();
                    if (fg.getInputAttributes().length == 2) {
                        a = this.newAttributeStart;
                        while (a < fsBestExampleSet.getAttributes().size()) {
                            int o = 0;
                            while (o < this.originalAttributes.length) {
                                FeatureGenerator g = fg.newInstance();
                                g.setArguments(new Attribute[]{this.originalAttributes[o], fsBestAttributes[a]});
                                generators.add(g);
                                ++o;
                            }
                            ++a;
                        }
                        continue;
                    }
                    if (fg.getInputAttributes().length == 1) {
                        a = 0;
                        while (a < fsBestAttributes.length) {
                            FeatureGenerator g = fg.newInstance();
                            g.setArguments(new Attribute[]{fsBestAttributes[a]});
                            generators.add(g);
                            ++a;
                        }
                        continue;
                    }
                    LogService.logMessage(String.valueOf(this.getName()) + ": functions with arity " + fg.getInputAttributes().length + " not supported: " + fg, 4);
                }
                LogService.logMessage(String.valueOf(this.getName()) + ": generating " + generators.size() + " new attributes.", 2);
                this.newAttributeStart = fsBestExampleSet.getAttributes().size();
                try {
                    List<Attribute> attributes = FeatureGenerator.generateAll(fsBestExampleSet.getExampleTable(), generators);
                    for (Attribute attr : attributes) {
                        try {
                            fsBestExampleSet.getAttributes().addRegular(attr);
                            fsBestExampleSet.setAttributeUsed(attr, false);
                        }
                        catch (Exception e) {
                            LogService.logMessage(String.valueOf(this.getName()) + ": " + e.getMessage(), 4);
                        }
                    }
                }
                catch (GenerationException e) {
                    throw new UserError((Operator)this, (Throwable)e, 108, (Object)e.getMessage());
                }
                pop.clear();
                pop.add(new Individual(fsBestExampleSet));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("reciprocal_value", "Generate reciprocal values.", true));
        types.add(new ParameterTypeBoolean("use_plus", "Generate sums.", true));
        types.add(new ParameterTypeBoolean("use_diff", "Generate differences.", true));
        types.add(new ParameterTypeBoolean("use_mult", "Generate products.", true));
        types.add(new ParameterTypeBoolean("use_div", "Generate quotients.", true));
        types.add(new ParameterTypeBoolean("use_max", "Generate maximum.", true));
        types.add(new ParameterTypeBoolean("restrictive_selection", "Use restrictive generator selection (faster).", true));
        return types;
    }
}

