/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.generator.AttributePeak;
import edu.udo.cs.yale.generator.SinusFactory;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierGenerator
extends IndividualOperator {
    private SinusFactory factory = null;
    private int startGenerations = 0;
    private int applyInGeneration = 1;
    private RandomGenerator random;

    public FourierGenerator(int maxPeaks, int adaptionType, int attributesPerPeak, double epsilon, RandomGenerator random) {
        this.factory = new SinusFactory(maxPeaks);
        this.factory.setAdaptionType(adaptionType);
        this.factory.setEpsilon(epsilon);
        this.factory.setAttributePerPeak(attributesPerPeak);
        this.random = random;
    }

    public void setStartGenerations(int startGenerations) {
        this.startGenerations = startGenerations;
    }

    public void setApplyInGeneration(int applyInGeneration) {
        this.applyInGeneration = applyInGeneration;
    }

    @Override
    public boolean performOperation(int generation) {
        return generation <= this.startGenerations || this.applyInGeneration != 0 && generation % this.applyInGeneration == 0;
    }

    @Override
    public List<Individual> operate(Individual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        Attribute label = exampleSet.getAttributes().getLabel();
        LinkedList<AttributePeak> attributes = new LinkedList<AttributePeak>();
        for (Attribute current : exampleSet.getAttributes()) {
            if (current.isNominal() || current.getConstruction().getDescription().indexOf("sin") != -1) continue;
            List<AttributePeak> peaks = this.factory.getAttributePeaks(exampleSet, label, current);
            attributes.addAll(peaks);
        }
        if (attributes.size() > 0) {
            this.factory.generateSinusFunctions(exampleSet, attributes, this.random);
        }
        LinkedList<Individual> result = new LinkedList<Individual>();
        result.add(new Individual(exampleSet));
        return result;
    }
}

