/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.AttributePeak;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.SinusFactory;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierGeneratingMutation
extends IndividualOperator {
    private List<FeatureGenerator> generators;
    private List<Attribute> originalAttributes;
    private double p;
    private int numberOfConstructed;
    private int numberOfOriginal;
    private SinusFactory factory = null;
    private int maxDepth;
    private String[] unusableFunctions = new String[0];
    private RandomGenerator random;

    public FourierGeneratingMutation(List<Attribute> originalAttributes, double p, List<FeatureGenerator> generators, int numberOfConstructed, int numberOfOriginal, int maxPeaks, int adaptionType, int attributesPerPeak, double epsilon, int maxDepth, String[] unusableFunctions, RandomGenerator random) {
        this.originalAttributes = originalAttributes;
        this.p = p;
        this.generators = generators;
        this.numberOfConstructed = numberOfConstructed;
        this.numberOfOriginal = numberOfOriginal;
        this.factory = new SinusFactory(maxPeaks);
        this.factory.setAdaptionType(adaptionType);
        this.factory.setEpsilon(epsilon);
        this.factory.setAttributePerPeak(attributesPerPeak);
        this.maxDepth = maxDepth;
        this.unusableFunctions = unusableFunctions;
        this.random = random;
    }

    @Override
    public List<Individual> operate(Individual individual) throws Exception {
        LinkedList<Individual> l = new LinkedList<Individual>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)individual.getExampleSet().clone();
        try {
            int numberOriginal = this.addOriginalAttribute(clone);
            int numberCreated = this.addGeneratedAttribute(clone);
            this.deselect(clone, numberOriginal + numberCreated);
        }
        catch (GenerationException e) {
            LogService.logMessage("GeneratingMutation: Exception occured during generation of attributes, using only original example set instead.", 4);
        }
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(new Individual(clone));
        }
        l.add(individual);
        return l;
    }

    private int addGeneratedAttribute(AttributeWeightedExampleSet exampleSet) throws OperatorException {
        int counter = 0;
        int k = 0;
        while (k < this.numberOfConstructed) {
            FeatureGenerator generator;
            if (this.random.nextDouble() < this.p && (generator = FeatureGenerator.selectGenerator(exampleSet, this.generators, this.maxDepth, this.unusableFunctions, this.random)) != null) {
                generator = generator.newInstance();
                Attribute[] args = Tools.getRandomCompatibleAttributes(exampleSet, generator, this.maxDepth, this.unusableFunctions, this.random);
                generator.setArguments(args);
                LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
                generatorList.add(generator);
                List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
                for (Attribute newAttribute : newAttributes) {
                    exampleSet.getAttributes().addRegular(newAttribute);
                }
                counter += newAttributes.size();
                Iterator<Attribute> i = newAttributes.iterator();
                LinkedList<AttributePeak> sinAttributes = new LinkedList<AttributePeak>();
                Attribute label = exampleSet.getAttributes().getLabel();
                while (i.hasNext()) {
                    Attribute current = i.next();
                    if (current.isNominal() || current.getConstruction().getDescription().indexOf("sin") != -1) continue;
                    List<AttributePeak> peaks = this.factory.getAttributePeaks(exampleSet, label, current);
                    sinAttributes.addAll(peaks);
                }
                if (sinAttributes.size() > 0) {
                    this.factory.generateSinusFunctions(exampleSet, sinAttributes, this.random);
                }
                counter += sinAttributes.size();
            }
            ++k;
        }
        return counter;
    }

    private int addOriginalAttribute(AttributeWeightedExampleSet exampleSet) throws GenerationException, OperatorException {
        int counter = 0;
        int k = 0;
        while (k < this.numberOfOriginal) {
            if (this.random.nextDouble() < this.p) {
                List<AttributePeak> peaks;
                int i = this.random.nextInt(this.originalAttributes.size());
                Attribute originalAttribute = this.originalAttributes.get(i);
                if (exampleSet.getAttributes().getRegular(originalAttribute.getName()) == null) {
                    exampleSet.getAttributes().addRegular(originalAttribute);
                    ++counter;
                }
                if ((peaks = this.factory.getAttributePeaks(exampleSet, exampleSet.getAttributes().getLabel(), originalAttribute)).size() > 0) {
                    this.factory.generateSinusFunctions(exampleSet, peaks, this.random);
                }
                counter += peaks.size();
            }
            ++k;
        }
        return counter;
    }

    private void deselect(AttributeWeightedExampleSet exampleSet, int numberNew) {
        double[] probs = Tools.getInverseProbabilitiesFromWeights(exampleSet.getAttributes().createRegularAttributeArray(), exampleSet);
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        int index = 0;
        while (i.hasNext()) {
            i.next();
            int n = index++;
            if (!(this.random.nextDouble() < this.p * probs[n] * (double)numberNew)) continue;
            i.remove();
        }
    }
}

