/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeParser;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureGenerationOperator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public FeatureGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        boolean keepAll = this.getParameterAsBoolean("keep_all");
        File file = this.getParameterAsFile("filename");
        try {
            AttributeParser parser = new AttributeParser(exampleSet.getExampleTable());
            if (file != null) {
                FileInputStream in = new FileInputStream(file);
                parser.parseAll(in);
                ((InputStream)in).close();
            }
            for (Object[] nameFunctionPair : this.getParameterList("functions")) {
                Attribute attribute = parser.parseAttribute((String)nameFunctionPair[1]);
                attribute.setName((String)nameFunctionPair[0]);
                this.checkForStop();
            }
            if (!keepAll) {
                exampleSet.getAttributes().clearRegular();
            }
            parser.generateAll(exampleSet);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{file, e.getMessage()});
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile("filename", "Create the attributes listed in this file (written by an AttributeConstructionsWriter).", "att", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList("functions", "List of functions to generate.", new ParameterTypeString("function", "Function and arguments to use for generation."));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("keep_all", "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", false));
        return types;
    }
}

