/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.construction.DirectedGeneratingMutation;
import edu.udo.cs.yale.operator.features.construction.YAGGA2;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGGA
extends YAGGA2 {
    public DirectedGGA(OperatorDescription description) {
        super(description);
    }

    @Override
    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        Attribute[] attributes = eSet.getAttributes().createRegularAttributeArray();
        return new DirectedGeneratingMutation(attributes, this.getParameterAsDouble("p_mutation"), generators, this.getParameterAsInt("max_generated"), this.getParameterAsInt("max_original"), this.getParameterAsInt("max_construction_depth"), this.getParameterAsString("unused_functions").split(" "), this.getRandom());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("max_generated", "The maximum number of generated attributes per generation.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt("max_original", "The maximum number of original attributes added per generation.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt("max_construction_depth", "The maximum depth for the argument attributes used for attribute construction (-a: allow all depths).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeString("unused_functions", "Space separated list of functions which are not allowed in arguments for attribute construction."));
        return types;
    }
}

