/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.generator.ConstantGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantGeneration
extends IndividualOperator {
    private double prob;
    private RandomGenerator random;

    public ConstantGeneration(double prob, RandomGenerator random) {
        this.prob = prob;
        this.random = random;
    }

    @Override
    public List<Individual> operate(Individual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        if (this.random.nextDouble() < this.prob) {
            ConstantGenerator generator = new ConstantGenerator(this.random.nextDoubleInRange(-10.0, 10.0));
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
            for (Attribute newAttribute : newAttributes) {
                exampleSet.getAttributes().addRegular(newAttribute);
            }
        }
        LinkedList<Individual> result = new LinkedList<Individual>();
        result.add(new Individual(exampleSet));
        return result;
    }
}

