/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.AbsoluteValueGenerator;
import edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator;
import edu.udo.cs.yale.generator.ExponentialFunctionGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.FloorCeilGenerator;
import edu.udo.cs.yale.generator.MinMaxGenerator;
import edu.udo.cs.yale.generator.PowerGenerator;
import edu.udo.cs.yale.generator.ReciprocalValueGenerator;
import edu.udo.cs.yale.generator.SquareRootGenerator;
import edu.udo.cs.yale.generator.TrigonometricFunctionGenerator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteFeatureGenerationOperator
extends Operator {
    public CompleteFeatureGenerationOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        FeatureGenerator.setSelectionMode(1);
        List<FeatureGenerator> generators = this.getGenerators();
        LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
        for (FeatureGenerator generator : generators) {
            List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, -1, new String[0]);
            for (Attribute[] args : inputAttributes) {
                FeatureGenerator newGenerator = generator.newInstance();
                newGenerator.setArguments(args);
                generatorList.add(newGenerator);
            }
        }
        if (!this.getParameterAsBoolean("keep_all")) {
            exampleSet.getAttributes().clearRegular();
        }
        List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
        for (Attribute newAttribute : newAttributes) {
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        return new IOObject[]{exampleSet};
    }

    private List<FeatureGenerator> getGenerators() {
        ArrayList<FeatureGenerator> generators = new ArrayList<FeatureGenerator>();
        if (this.getParameterAsBoolean("use_plus")) {
            generators.add(new BasicArithmeticOperationGenerator(0));
        }
        if (this.getParameterAsBoolean("use_diff")) {
            generators.add(new BasicArithmeticOperationGenerator(1));
        }
        if (this.getParameterAsBoolean("use_mult")) {
            generators.add(new BasicArithmeticOperationGenerator(2));
        }
        if (this.getParameterAsBoolean("use_div")) {
            generators.add(new BasicArithmeticOperationGenerator(3));
        }
        if (this.getParameterAsBoolean("use_reciprocals")) {
            generators.add(new ReciprocalValueGenerator());
        }
        if (this.getParameterAsBoolean("use_square_roots")) {
            generators.add(new SquareRootGenerator());
        }
        if (this.getParameterAsBoolean("use_power_functions")) {
            generators.add(new PowerGenerator());
        }
        if (this.getParameterAsBoolean("use_sin")) {
            generators.add(new TrigonometricFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean("use_cos")) {
            generators.add(new TrigonometricFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean("use_tan")) {
            generators.add(new TrigonometricFunctionGenerator(2));
        }
        if (this.getParameterAsBoolean("use_atan")) {
            generators.add(new TrigonometricFunctionGenerator(3));
        }
        if (this.getParameterAsBoolean("use_exp")) {
            generators.add(new ExponentialFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean("use_log")) {
            generators.add(new ExponentialFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean("use_absolute_values")) {
            generators.add(new AbsoluteValueGenerator());
        }
        if (this.getParameterAsBoolean("use_min")) {
            generators.add(new MinMaxGenerator(0));
        }
        if (this.getParameterAsBoolean("use_max")) {
            generators.add(new MinMaxGenerator(1));
        }
        if (this.getParameterAsBoolean("use_ceil")) {
            generators.add(new FloorCeilGenerator(1));
        }
        if (this.getParameterAsBoolean("use_floor")) {
            generators.add(new FloorCeilGenerator(0));
        }
        if (this.getParameterAsBoolean("use_rounded")) {
            generators.add(new FloorCeilGenerator(2));
        }
        return generators;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("keep_all", "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", true));
        types.add(new ParameterTypeBoolean("use_plus", "Generate sums.", false));
        types.add(new ParameterTypeBoolean("use_diff", "Generate differences.", false));
        types.add(new ParameterTypeBoolean("use_mult", "Generate products.", false));
        types.add(new ParameterTypeBoolean("use_div", "Generate quotients.", false));
        types.add(new ParameterTypeBoolean("use_reciprocals", "Generate reciprocal values.", false));
        types.add(new ParameterTypeBoolean("use_square_roots", "Generate square root values.", false));
        types.add(new ParameterTypeBoolean("use_power_functions", "Generate the power of one attribute and another.", false));
        types.add(new ParameterTypeBoolean("use_sin", "Generate sinus.", false));
        types.add(new ParameterTypeBoolean("use_cos", "Generate cosinus.", false));
        types.add(new ParameterTypeBoolean("use_tan", "Generate tangens.", false));
        types.add(new ParameterTypeBoolean("use_atan", "Generate arc tangens.", false));
        types.add(new ParameterTypeBoolean("use_exp", "Generate exponential functions.", false));
        types.add(new ParameterTypeBoolean("use_log", "Generate logarithmic functions.", false));
        types.add(new ParameterTypeBoolean("use_absolute_values", "Generate absolute values.", false));
        types.add(new ParameterTypeBoolean("use_min", "Generate minimum values.", false));
        types.add(new ParameterTypeBoolean("use_max", "Generate maximum values.", false));
        types.add(new ParameterTypeBoolean("use_ceil", "Generate ceil values.", false));
        types.add(new ParameterTypeBoolean("use_floor", "Generate floor values.", false));
        types.add(new ParameterTypeBoolean("use_rounded", "Generate rounded values.", false));
        return types;
    }
}

