/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGenerator
extends IndividualOperator {
    private double pGenerate;
    private int numberOfNewAttributes;
    private int totalMaxNumberOfAttributes;
    private List<FeatureGenerator> generatorList;
    private RandomGenerator random;

    public AttributeGenerator(double pGenerate, int numberOfNewAttributes, int totalMaxNumberOfAttributes, List<FeatureGenerator> generatorList, RandomGenerator random) {
        this.pGenerate = pGenerate;
        this.numberOfNewAttributes = numberOfNewAttributes;
        this.totalMaxNumberOfAttributes = totalMaxNumberOfAttributes;
        this.generatorList = generatorList;
        this.random = random;
    }

    @Override
    public List<Individual> operate(Individual individual) throws Exception {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        ArrayList<FeatureGenerator> selectedGeneratorList = new ArrayList<FeatureGenerator>();
        if (this.totalMaxNumberOfAttributes < 0 || exampleSet.getAttributes().size() < this.totalMaxNumberOfAttributes) {
            int h = 0;
            while (h < this.numberOfNewAttributes) {
                FeatureGenerator generator;
                if (this.random.nextDouble() < this.pGenerate && (generator = FeatureGenerator.selectGenerator(exampleSet, this.generatorList, -1, new String[0], this.random)) != null) {
                    generator = generator.newInstance();
                    Attribute[] args = Tools.getRandomCompatibleAttributes(exampleSet, generator, -1, new String[0], this.random);
                    generator.setArguments(args);
                    selectedGeneratorList.add(generator);
                }
                ++h;
            }
            if (selectedGeneratorList.size() > 0) {
                List<Attribute> newAttributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), selectedGeneratorList);
                for (Attribute newAttribute : newAttributes) {
                    exampleSet.getAttributes().addRegular(newAttribute);
                }
            }
        }
        LinkedList<Individual> result = new LinkedList<Individual>();
        result.add(new Individual(exampleSet));
        return result;
    }
}

