/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.ReciprocalValueGenerator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.construction.UnbalancedCrossover;
import edu.udo.cs.yale.operator.features.selection.AbstractGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.selection.SelectionCrossover;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratingGeneticAlgorithm
extends AbstractGeneticAlgorithm {
    public AbstractGeneratingGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    protected abstract PopulationOperator getGeneratingPopulationOperator(ExampleSet var1) throws OperatorException;

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        Population initP = new Population();
        while (initP.getNumberOfIndividuals() < this.getParameterAsInt("population_size")) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            for (Attribute attribute : nes.getAttributes()) {
                if (!(this.getRandom().nextDouble() < this.getParameterAsDouble("p_initialize"))) continue;
                nes.flipAttributeUsed(attribute);
            }
            if (nes.getNumberOfUsedAttributes() <= 0) continue;
            initP.add(new Individual(nes));
        }
        return initP;
    }

    @Override
    protected List<PopulationOperator> getPreProcessingPopulationOperators(ExampleSet exampleSet) throws OperatorException {
        List<PopulationOperator> popOps = super.getPreProcessingPopulationOperators(exampleSet);
        PopulationOperator generator = this.getGeneratingPopulationOperator(exampleSet);
        if (generator != null) {
            popOps.add(generator);
        }
        return popOps;
    }

    @Override
    protected PopulationOperator getCrossoverPopulationOperator(ExampleSet exampleSet) throws UndefinedParameterError {
        double pCrossover = this.getParameterAsDouble("p_crossover");
        int crossoverType = this.getParameterAsInt("crossover_type");
        return new UnbalancedCrossover(crossoverType, pCrossover, this.getRandom());
    }

    public List<FeatureGenerator> getGenerators() {
        ArrayList<FeatureGenerator> generators = new ArrayList<FeatureGenerator>();
        if (this.getParameterAsBoolean("use_plus")) {
            generators.add(new BasicArithmeticOperationGenerator(0));
        }
        if (this.getParameterAsBoolean("use_diff")) {
            generators.add(new BasicArithmeticOperationGenerator(1));
        }
        if (this.getParameterAsBoolean("use_mult")) {
            generators.add(new BasicArithmeticOperationGenerator(2));
        }
        if (this.getParameterAsBoolean("use_div")) {
            generators.add(new BasicArithmeticOperationGenerator(3));
        }
        if (this.getParameterAsBoolean("reciprocal_value")) {
            generators.add(new ReciprocalValueGenerator());
        }
        return generators;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("p_initialize", "Initial probability for an attribute to be switched on.", 0.0, 1.0, 0.5));
        ParameterTypeDouble type = new ParameterTypeDouble("p_crossover", "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("crossover_type", "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeBoolean("use_plus", "Generate sums.", true));
        types.add(new ParameterTypeBoolean("use_diff", "Generate differences.", false));
        types.add(new ParameterTypeBoolean("use_mult", "Generate products.", true));
        types.add(new ParameterTypeBoolean("use_div", "Generate quotients.", false));
        types.add(new ParameterTypeBoolean("reciprocal_value", "Generate reciprocal values.", true));
        return types;
    }
}

