/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.construction;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.AbsoluteValueGenerator;
import edu.udo.cs.yale.generator.ExponentialFunctionGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.FloorCeilGenerator;
import edu.udo.cs.yale.generator.MinMaxGenerator;
import edu.udo.cs.yale.generator.PowerGenerator;
import edu.udo.cs.yale.generator.SinusFactory;
import edu.udo.cs.yale.generator.SquareRootGenerator;
import edu.udo.cs.yale.generator.TrigonometricFunctionGenerator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.EquivalentAttributeRemoval;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.RemoveUselessAttributes;
import edu.udo.cs.yale.operator.features.construction.FourierGenerator;
import edu.udo.cs.yale.operator.features.construction.GeneratingGeneticAlgorithm;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AGA
extends GeneratingGeneticAlgorithm {
    public AGA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        if (this.getParameterAsBoolean("restrictive_selection")) {
            FeatureGenerator.setSelectionMode(1);
        } else {
            FeatureGenerator.setSelectionMode(0);
        }
        return super.apply();
    }

    @Override
    public List<FeatureGenerator> getGenerators() {
        List<FeatureGenerator> generators = super.getGenerators();
        if (this.getParameterAsBoolean("use_square_roots")) {
            generators.add(new SquareRootGenerator());
        }
        if (this.getParameterAsBoolean("use_power_functions")) {
            generators.add(new PowerGenerator());
        }
        if (this.getParameterAsBoolean("use_sin")) {
            generators.add(new TrigonometricFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean("use_cos")) {
            generators.add(new TrigonometricFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean("use_tan")) {
            generators.add(new TrigonometricFunctionGenerator(2));
        }
        if (this.getParameterAsBoolean("use_atan")) {
            generators.add(new TrigonometricFunctionGenerator(3));
        }
        if (this.getParameterAsBoolean("use_exp")) {
            generators.add(new ExponentialFunctionGenerator(0));
        }
        if (this.getParameterAsBoolean("use_log")) {
            generators.add(new ExponentialFunctionGenerator(1));
        }
        if (this.getParameterAsBoolean("use_absolute_values")) {
            generators.add(new AbsoluteValueGenerator());
        }
        if (this.getParameterAsBoolean("use_min")) {
            generators.add(new MinMaxGenerator(0));
        }
        if (this.getParameterAsBoolean("use_max")) {
            generators.add(new MinMaxGenerator(1));
        }
        if (this.getParameterAsBoolean("use_floor_ceil_functions")) {
            generators.add(new FloorCeilGenerator(0));
            generators.add(new FloorCeilGenerator(1));
            generators.add(new FloorCeilGenerator(2));
        }
        return generators;
    }

    @Override
    protected List<PopulationOperator> getPreProcessingPopulationOperators(ExampleSet input) throws OperatorException {
        int maxPeaks;
        List<PopulationOperator> popOps = super.getPreProcessingPopulationOperators(input);
        if (this.getParameterAsBoolean("remove_useless")) {
            popOps.add(new RemoveUselessAttributes());
        }
        if (this.getParameterAsBoolean("remove_equivalent")) {
            popOps.add(new EquivalentAttributeRemoval(this.getParameterAsInt("equivalence_samples"), this.getParameterAsDouble("equivalence_epsilon"), this.getParameterAsBoolean("equivalence_use_statistics"), this.getRandom()));
        }
        if ((maxPeaks = this.getParameterAsInt("search_fourier_peaks")) > 0) {
            popOps.add(new FourierGenerator(maxPeaks, this.getParameterAsInt("adaption_type"), this.getParameterAsInt("attributes_per_peak"), this.getParameterAsDouble("epsilon"), this.getRandom()));
        }
        return popOps;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("use_square_roots", "Generate square root values.", false));
        types.add(new ParameterTypeBoolean("use_power_functions", "Generate the power of one attribute and another.", false));
        types.add(new ParameterTypeBoolean("use_sin", "Generate sinus.", false));
        types.add(new ParameterTypeBoolean("use_cos", "Generate cosinus.", false));
        types.add(new ParameterTypeBoolean("use_tan", "Generate tangens.", false));
        types.add(new ParameterTypeBoolean("use_atan", "Generate arc tangens.", false));
        types.add(new ParameterTypeBoolean("use_exp", "Generate exponential functions.", false));
        types.add(new ParameterTypeBoolean("use_log", "Generate logarithmic functions.", false));
        types.add(new ParameterTypeBoolean("use_absolute_values", "Generate absolute values.", false));
        types.add(new ParameterTypeBoolean("use_min", "Generate minimum values.", false));
        types.add(new ParameterTypeBoolean("use_max", "Generate maximum values.", false));
        types.add(new ParameterTypeBoolean("use_floor_ceil_functions", "Generate floor, ceil, and rounded values.", false));
        types.add(new ParameterTypeBoolean("restrictive_selection", "Use restrictive generator selection (faster).", true));
        types.add(new ParameterTypeBoolean("remove_useless", "Remove useless attributes.", true));
        types.add(new ParameterTypeBoolean("remove_equivalent", "Remove equivalent attributes.", true));
        types.add(new ParameterTypeInt("equivalence_samples", "Check this number of samples to prove equivalency.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble("equivalence_epsilon", "Consider two attributes equivalent if their difference is not bigger than epsilon.", 0.0, Double.POSITIVE_INFINITY, 0.05));
        types.add(new ParameterTypeBoolean("equivalence_use_statistics", "Recalculates attribute statistics before equivalence check.", true));
        types.add(new ParameterTypeInt("search_fourier_peaks", "Use this number of highest frequency peaks for sinus generation.", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeInt("attributes_per_peak", "Use this number of additional peaks for each found peak.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeDouble("epsilon", "Use this range for additional peaks for each found peak.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeCategory("adaption_type", "Use this adaption type for additional peaks.", SinusFactory.ADAPTION_TYPES, 2));
        return types;
    }
}

