/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.aggregation;

import edu.udo.cs.yale.datatable.SimpleDataTable;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.AlgebraicOrGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.MinMaxGenerator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.condition.LastInnerOperatorCondition;
import edu.udo.cs.yale.operator.features.aggregation.AggregationCrossover;
import edu.udo.cs.yale.operator.features.aggregation.AggregationIndividual;
import edu.udo.cs.yale.operator.features.aggregation.AggregationMutation;
import edu.udo.cs.yale.operator.features.aggregation.AggregationNonDominatedSortingSelection;
import edu.udo.cs.yale.operator.features.aggregation.AggregationPopulationPlotter;
import edu.udo.cs.yale.operator.features.aggregation.AggregationSelection;
import edu.udo.cs.yale.operator.features.aggregation.AggregationTournamentSelection;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionaryFeatureAggregation
extends OperatorChain {
    private static final String[] SELECTION_TYPES = new String[]{"tournament", "non-dominated"};
    private static final int SELECTION_TOURNAMENT = 0;
    private static final int SELECTION_MO = 1;
    private static final String[] AGGREGATION_FUNCTIONS = new String[]{"maximum", "algebraic_or"};
    private static final int AGGREGATION_MAX = 0;
    private static final int AGGREGATION_ALGEBRAIC = 1;
    private Attribute[] allAttributes;
    private FeatureGenerator generator = new MinMaxGenerator(1);
    private int generation = 0;
    private int maxGeneration = 100;

    public EvolutionaryFeatureAggregation(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int popSize = this.getParameterAsInt("population_size");
        this.generation = 0;
        this.maxGeneration = this.getParameterAsInt("maximum_number_of_generations");
        int functionType = this.getParameterAsInt("aggregation_function");
        switch (functionType) {
            case 0: {
                this.generator = new MinMaxGenerator(1);
                break;
            }
            case 1: {
                this.generator = new AlgebraicOrGenerator();
            }
        }
        RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt("local_random_seed"));
        this.allAttributes = new Attribute[exampleSet.getAttributes().size()];
        int index = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.allAttributes[index++] = attribute;
        }
        AggregationPopulationPlotter plotter = new AggregationPopulationPlotter(exampleSet, this.allAttributes, this.generator);
        AggregationCrossover crossover = new AggregationCrossover(this.getParameterAsInt("crossover_type"), this.getParameterAsDouble("p_crossover"), random);
        AggregationMutation mutation = new AggregationMutation(random);
        int selectionType = this.getParameterAsInt("selection_type");
        AggregationSelection selection = null;
        switch (selectionType) {
            case 0: {
                selection = new AggregationTournamentSelection(popSize, this.getParameterAsDouble("tournament_fraction"), random);
                break;
            }
            case 1: {
                selection = new AggregationNonDominatedSortingSelection(popSize);
            }
        }
        List<AggregationIndividual> population = this.createInitialPopulation(popSize, exampleSet.getAttributes().size(), random);
        while (!this.solutionGoodEnough()) {
            ++this.generation;
            crossover.crossover(population);
            mutation.mutate(population);
            this.evaluate(population, exampleSet);
            selection.performSelection(population);
            plotter.operate(population);
            this.inApplyLoop();
        }
        if (this.isParameterSet("population_criteria_data_file")) {
            File outFile = this.getParameterAsFile("population_criteria_data_file");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(outFile));
                SimpleDataTable finalStatistics = plotter.createDataTable(population);
                plotter.fillDataTable(finalStatistics, population);
                finalStatistics.write(out);
                out.close();
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{outFile, e.getMessage()});
            }
        }
        this.evaluate(population, exampleSet);
        Iterator<AggregationIndividual> i = population.iterator();
        AggregationIndividual bestEver = null;
        PerformanceVector bestPerformance = null;
        while (i.hasNext()) {
            AggregationIndividual current = i.next();
            PerformanceVector currentPerf = current.getPerformance();
            if (bestPerformance != null && currentPerf.compareTo(bestPerformance) <= 0) continue;
            bestPerformance = currentPerf;
            bestEver = current;
        }
        return new IOObject[]{bestEver.createExampleSet(exampleSet, this.allAttributes, this.generator), bestPerformance};
    }

    private List<AggregationIndividual> createInitialPopulation(int popSize, int individualSize, Random random) {
        ArrayList<AggregationIndividual> population = new ArrayList<AggregationIndividual>();
        int i = 0;
        while (i < popSize) {
            int[] individual = new int[individualSize];
            int a = 0;
            while (a < individual.length) {
                individual[a] = random.nextBoolean() ? 0 : -1;
                ++a;
            }
            population.add(new AggregationIndividual(individual));
            ++i;
        }
        return population;
    }

    private boolean solutionGoodEnough() {
        return this.generation > this.maxGeneration;
    }

    public void evaluate(List population, ExampleSet originalExampleSet) throws OperatorException {
        Iterator i = population.iterator();
        while (i.hasNext()) {
            AggregationIndividual individual = (AggregationIndividual)i.next();
            if (individual.getPerformance() != null) continue;
            ExampleSet exampleSet = individual.createExampleSet(originalExampleSet, this.allAttributes, this.generator);
            if (exampleSet.getAttributes().size() == 0) {
                i.remove();
                continue;
            }
            IOObject[] operatorChainInput = new IOObject[]{exampleSet};
            IOContainer innerResult = this.getInput().prepend(operatorChainInput);
            int j = 0;
            while (j < this.getNumberOfOperators()) {
                innerResult = this.getOperator(j).apply(innerResult);
                ++j;
            }
            PerformanceVector performanceVector = innerResult.remove(PerformanceVector.class);
            individual.setPerformance(performanceVector);
        }
    }

    @Override
    public Class[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class[] getOutputClasses() {
        return new Class[]{ExampleSet.class, PerformanceVector.class};
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile("population_criteria_data_file", "The path to the file in which the criteria data of the final population should be saved.", "crit", true));
        ParameterTypeSingle type = new ParameterTypeCategory("aggregation_function", "The aggregation function which is used for feature aggregations.", AGGREGATION_FUNCTIONS, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("population_size", "Number of individuals per generation.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("maximum_number_of_generations", "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("selection_type", "The type of selection.", SELECTION_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("tournament_fraction", "The fraction of the population which will participate in each tournament.", 0.0, 1.0, 0.2));
        types.add(new ParameterTypeCategory("crossover_type", "The type of crossover.", AggregationCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeDouble("p_crossover", "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.9));
        types.add(new ParameterTypeInt("local_random_seed", "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

